/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micronaut.configuration.mongo.core.CodecRegistryBuilder;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

public abstract class AbstractMongoConfiguration {
    private String uri;
    private final ApplicationConfiguration applicationConfiguration;
    private List<Codec<?>> codecList = Collections.emptyList();
    private List<CodecRegistry> codecRegistries = Collections.emptyList();
    private List<CommandListener> commandListeners = Collections.emptyList();
    private List<ConnectionPoolListener> connectionPoolListeners = Collections.emptyList();
    private Collection<String> packageNames;
    private boolean automaticClassModels = true;
    private CodecRegistryBuilder codecRegistryBuilder;
    private boolean useSerde;

    protected AbstractMongoConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public void codecs(List<Codec<?>> codecList) {
        if (codecList != null) {
            this.codecList = codecList;
        }
    }

    public void codecRegistries(List<CodecRegistry> codecRegistries) {
        if (codecRegistries != null) {
            this.codecRegistries = codecRegistries;
        }
    }

    public void commandListeners(List<CommandListener> commandListeners) {
        if (commandListeners != null) {
            this.commandListeners = commandListeners;
        }
    }

    public void connectionPoolListeners(List<ConnectionPoolListener> connectionPoolListeners) {
        if (connectionPoolListeners != null) {
            this.connectionPoolListeners = connectionPoolListeners;
        }
    }

    public void packages(Collection<String> packageNames) {
        if (packageNames != null) {
            this.packageNames = packageNames;
        }
    }

    public List<Codec<?>> getCodecs() {
        return this.codecList;
    }

    public List<CodecRegistry> getCodecRegistries() {
        return this.codecRegistries;
    }

    public List<CommandListener> getCommandListeners() {
        return this.commandListeners;
    }

    public List<ConnectionPoolListener> getConnectionPoolListeners() {
        return this.connectionPoolListeners;
    }

    @NotBlank
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        Optional<ConnectionString> connectionString = this.getConnectionString();
        if (connectionString.isPresent()) {
            ConnectionString cs = connectionString.get();
            this.getClientSettings().applyConnectionString(cs);
            this.getServerSettings().applyConnectionString(cs);
            this.getClusterSettings().applyConnectionString(cs);
            this.getPoolSettings().applyConnectionString(cs);
            this.getSslSettings().applyConnectionString(cs);
            this.getSocketSettings().applyConnectionString(cs);
        }
    }

    public void setPackageNames(Collection<String> packageNames) {
        this.packageNames = packageNames;
    }

    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    public void setAutomaticClassModels(boolean automaticClassModels) {
        this.automaticClassModels = automaticClassModels;
    }

    public boolean isAutomaticClassModels() {
        return this.automaticClassModels;
    }

    public Optional<ConnectionString> getConnectionString() {
        if (StringUtils.isNotEmpty((CharSequence)this.uri)) {
            return Optional.of(new ConnectionString(this.uri));
        }
        return Optional.empty();
    }

    public abstract ClusterSettings.Builder getClusterSettings();

    public abstract MongoClientSettings.Builder getClientSettings();

    public abstract ServerSettings.Builder getServerSettings();

    public abstract ConnectionPoolSettings.Builder getPoolSettings();

    public abstract SocketSettings.Builder getSocketSettings();

    public abstract SslSettings.Builder getSslSettings();

    public MongoClientSettings buildSettings() {
        ClusterSettings.Builder clusterSettings = this.getClusterSettings();
        SslSettings.Builder sslSettings = this.getSslSettings();
        ConnectionPoolSettings.Builder poolSettings = this.getPoolSettings();
        SocketSettings.Builder socketSettings = this.getSocketSettings();
        ServerSettings.Builder serverSettings = this.getServerSettings();
        MongoClientSettings.Builder clientSettings = this.getClientSettings();
        clientSettings.applicationName(this.getApplicationName());
        clientSettings.applyToClusterSettings(builder -> builder.applySettings(clusterSettings.build()));
        clientSettings.applyToServerSettings(builder -> builder.applySettings(serverSettings.build()));
        clientSettings.applyToConnectionPoolSettings(builder -> {
            builder.applySettings(poolSettings.build());
            this.connectionPoolListeners.forEach(arg_0 -> ((ConnectionPoolSettings.Builder)builder).addConnectionPoolListener(arg_0));
        });
        clientSettings.applyToSocketSettings(builder -> builder.applySettings(socketSettings.build()));
        clientSettings.applyToSslSettings(builder -> builder.applySettings(sslSettings.build()));
        clientSettings.codecRegistry(this.codecRegistryBuilder.build(this));
        clientSettings.commandListenerList(this.commandListeners);
        return clientSettings.build();
    }

    protected void addDefaultCodecRegistry(List<CodecRegistry> codecRegistries) {
        codecRegistries.add(MongoClientSettings.getDefaultCodecRegistry());
    }

    public void setCodecRegistryBuilder(CodecRegistryBuilder codecRegistryBuilder) {
        this.codecRegistryBuilder = codecRegistryBuilder;
    }

    protected String getApplicationName() {
        return this.applicationConfiguration.getName().orElse("application");
    }

    public boolean isUseSerde() {
        return this.useSerde;
    }

    public void setUseSerde(boolean useSerde) {
        this.useSerde = useSerde;
    }
}

