/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.dataflow;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dataflow.DataFlowAsyncClient;
import com.oracle.bmc.dataflow.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePoolCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeRunCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeSqlEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.CreateApplicationRequest;
import com.oracle.bmc.dataflow.requests.CreatePoolRequest;
import com.oracle.bmc.dataflow.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateRunRequest;
import com.oracle.bmc.dataflow.requests.CreateSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateStatementRequest;
import com.oracle.bmc.dataflow.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataflow.requests.DeletePoolRequest;
import com.oracle.bmc.dataflow.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteRunRequest;
import com.oracle.bmc.dataflow.requests.DeleteSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteStatementRequest;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPoolRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetStatementRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPoolsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListSqlEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListStatementsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.requests.StartPoolRequest;
import com.oracle.bmc.dataflow.requests.StopPoolRequest;
import com.oracle.bmc.dataflow.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataflow.requests.UpdatePoolRequest;
import com.oracle.bmc.dataflow.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.requests.UpdateSqlEndpointRequest;
import com.oracle.bmc.dataflow.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePoolCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeRunCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeSqlEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.CreateApplicationResponse;
import com.oracle.bmc.dataflow.responses.CreatePoolResponse;
import com.oracle.bmc.dataflow.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateRunResponse;
import com.oracle.bmc.dataflow.responses.CreateSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateStatementResponse;
import com.oracle.bmc.dataflow.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataflow.responses.DeletePoolResponse;
import com.oracle.bmc.dataflow.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteRunResponse;
import com.oracle.bmc.dataflow.responses.DeleteSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteStatementResponse;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPoolResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetStatementResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPoolsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListSqlEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListStatementsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataflow.responses.StartPoolResponse;
import com.oracle.bmc.dataflow.responses.StopPoolResponse;
import com.oracle.bmc.dataflow.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataflow.responses.UpdatePoolResponse;
import com.oracle.bmc.dataflow.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import com.oracle.bmc.dataflow.responses.UpdateSqlEndpointResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DataFlowAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DataFlowReactorClient {
    DataFlowAsyncClient client;

    DataFlowReactorClient(DataFlowAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeApplicationCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangePoolCompartmentResponse> changePoolCompartment(ChangePoolCompartmentRequest request) {
        return Mono.create(sink -> this.client.changePoolCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangePrivateEndpointCompartmentResponse> changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request) {
        return Mono.create(sink -> this.client.changePrivateEndpointCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeRunCompartmentResponse> changeRunCompartment(ChangeRunCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeRunCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeSqlEndpointCompartmentResponse> changeSqlEndpointCompartment(ChangeSqlEndpointCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeSqlEndpointCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateApplicationResponse> createApplication(CreateApplicationRequest request) {
        return Mono.create(sink -> this.client.createApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreatePoolResponse> createPool(CreatePoolRequest request) {
        return Mono.create(sink -> this.client.createPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreatePrivateEndpointResponse> createPrivateEndpoint(CreatePrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.createPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateRunResponse> createRun(CreateRunRequest request) {
        return Mono.create(sink -> this.client.createRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSqlEndpointResponse> createSqlEndpoint(CreateSqlEndpointRequest request) {
        return Mono.create(sink -> this.client.createSqlEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateStatementResponse> createStatement(CreateStatementRequest request) {
        return Mono.create(sink -> this.client.createStatement(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request) {
        return Mono.create(sink -> this.client.deleteApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeletePoolResponse> deletePool(DeletePoolRequest request) {
        return Mono.create(sink -> this.client.deletePool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeletePrivateEndpointResponse> deletePrivateEndpoint(DeletePrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.deletePrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRunResponse> deleteRun(DeleteRunRequest request) {
        return Mono.create(sink -> this.client.deleteRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSqlEndpointResponse> deleteSqlEndpoint(DeleteSqlEndpointRequest request) {
        return Mono.create(sink -> this.client.deleteSqlEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteStatementResponse> deleteStatement(DeleteStatementRequest request) {
        return Mono.create(sink -> this.client.deleteStatement(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetApplicationResponse> getApplication(GetApplicationRequest request) {
        return Mono.create(sink -> this.client.getApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPoolResponse> getPool(GetPoolRequest request) {
        return Mono.create(sink -> this.client.getPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPrivateEndpointResponse> getPrivateEndpoint(GetPrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.getPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRunResponse> getRun(GetRunRequest request) {
        return Mono.create(sink -> this.client.getRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRunLogResponse> getRunLog(GetRunLogRequest request) {
        return Mono.create(sink -> this.client.getRunLog(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSqlEndpointResponse> getSqlEndpoint(GetSqlEndpointRequest request) {
        return Mono.create(sink -> this.client.getSqlEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetStatementResponse> getStatement(GetStatementRequest request) {
        return Mono.create(sink -> this.client.getStatement(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListApplicationsResponse> listApplications(ListApplicationsRequest request) {
        return Mono.create(sink -> this.client.listApplications(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListPoolsResponse> listPools(ListPoolsRequest request) {
        return Mono.create(sink -> this.client.listPools(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListPrivateEndpointsResponse> listPrivateEndpoints(ListPrivateEndpointsRequest request) {
        return Mono.create(sink -> this.client.listPrivateEndpoints(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRunLogsResponse> listRunLogs(ListRunLogsRequest request) {
        return Mono.create(sink -> this.client.listRunLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRunsResponse> listRuns(ListRunsRequest request) {
        return Mono.create(sink -> this.client.listRuns(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSqlEndpointsResponse> listSqlEndpoints(ListSqlEndpointsRequest request) {
        return Mono.create(sink -> this.client.listSqlEndpoints(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListStatementsResponse> listStatements(ListStatementsRequest request) {
        return Mono.create(sink -> this.client.listStatements(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartPoolResponse> startPool(StartPoolRequest request) {
        return Mono.create(sink -> this.client.startPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StopPoolResponse> stopPool(StopPoolRequest request) {
        return Mono.create(sink -> this.client.stopPool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request) {
        return Mono.create(sink -> this.client.updateApplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdatePoolResponse> updatePool(UpdatePoolRequest request) {
        return Mono.create(sink -> this.client.updatePool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdatePrivateEndpointResponse> updatePrivateEndpoint(UpdatePrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.updatePrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRunResponse> updateRun(UpdateRunRequest request) {
        return Mono.create(sink -> this.client.updateRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSqlEndpointResponse> updateSqlEndpoint(UpdateSqlEndpointRequest request) {
        return Mono.create(sink -> this.client.updateSqlEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

