/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.email;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.email.EmailAsyncClient;
import com.oracle.bmc.email.requests.ChangeEmailDomainCompartmentRequest;
import com.oracle.bmc.email.requests.ChangeSenderCompartmentRequest;
import com.oracle.bmc.email.requests.CreateDkimRequest;
import com.oracle.bmc.email.requests.CreateEmailDomainRequest;
import com.oracle.bmc.email.requests.CreateEmailReturnPathRequest;
import com.oracle.bmc.email.requests.CreateSenderRequest;
import com.oracle.bmc.email.requests.CreateSuppressionRequest;
import com.oracle.bmc.email.requests.DeleteDkimRequest;
import com.oracle.bmc.email.requests.DeleteEmailDomainRequest;
import com.oracle.bmc.email.requests.DeleteEmailReturnPathRequest;
import com.oracle.bmc.email.requests.DeleteSenderRequest;
import com.oracle.bmc.email.requests.DeleteSuppressionRequest;
import com.oracle.bmc.email.requests.GetDkimRequest;
import com.oracle.bmc.email.requests.GetEmailConfigurationRequest;
import com.oracle.bmc.email.requests.GetEmailDomainRequest;
import com.oracle.bmc.email.requests.GetEmailReturnPathRequest;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.requests.GetSuppressionRequest;
import com.oracle.bmc.email.requests.GetWorkRequestRequest;
import com.oracle.bmc.email.requests.ListDkimsRequest;
import com.oracle.bmc.email.requests.ListEmailDomainsRequest;
import com.oracle.bmc.email.requests.ListEmailReturnPathsRequest;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.email.requests.ListWorkRequestsRequest;
import com.oracle.bmc.email.requests.UpdateDkimRequest;
import com.oracle.bmc.email.requests.UpdateEmailDomainRequest;
import com.oracle.bmc.email.requests.UpdateEmailReturnPathRequest;
import com.oracle.bmc.email.requests.UpdateSenderRequest;
import com.oracle.bmc.email.responses.ChangeEmailDomainCompartmentResponse;
import com.oracle.bmc.email.responses.ChangeSenderCompartmentResponse;
import com.oracle.bmc.email.responses.CreateDkimResponse;
import com.oracle.bmc.email.responses.CreateEmailDomainResponse;
import com.oracle.bmc.email.responses.CreateEmailReturnPathResponse;
import com.oracle.bmc.email.responses.CreateSenderResponse;
import com.oracle.bmc.email.responses.CreateSuppressionResponse;
import com.oracle.bmc.email.responses.DeleteDkimResponse;
import com.oracle.bmc.email.responses.DeleteEmailDomainResponse;
import com.oracle.bmc.email.responses.DeleteEmailReturnPathResponse;
import com.oracle.bmc.email.responses.DeleteSenderResponse;
import com.oracle.bmc.email.responses.DeleteSuppressionResponse;
import com.oracle.bmc.email.responses.GetDkimResponse;
import com.oracle.bmc.email.responses.GetEmailConfigurationResponse;
import com.oracle.bmc.email.responses.GetEmailDomainResponse;
import com.oracle.bmc.email.responses.GetEmailReturnPathResponse;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.email.responses.GetSuppressionResponse;
import com.oracle.bmc.email.responses.GetWorkRequestResponse;
import com.oracle.bmc.email.responses.ListDkimsResponse;
import com.oracle.bmc.email.responses.ListEmailDomainsResponse;
import com.oracle.bmc.email.responses.ListEmailReturnPathsResponse;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.email.responses.ListWorkRequestsResponse;
import com.oracle.bmc.email.responses.UpdateDkimResponse;
import com.oracle.bmc.email.responses.UpdateEmailDomainResponse;
import com.oracle.bmc.email.responses.UpdateEmailReturnPathResponse;
import com.oracle.bmc.email.responses.UpdateSenderResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={EmailAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EmailReactorClient {
    EmailAsyncClient client;

    EmailReactorClient(EmailAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeEmailDomainCompartmentResponse> changeEmailDomainCompartment(ChangeEmailDomainCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeEmailDomainCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeSenderCompartmentResponse> changeSenderCompartment(ChangeSenderCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeSenderCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDkimResponse> createDkim(CreateDkimRequest request) {
        return Mono.create(sink -> this.client.createDkim(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateEmailDomainResponse> createEmailDomain(CreateEmailDomainRequest request) {
        return Mono.create(sink -> this.client.createEmailDomain(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateEmailReturnPathResponse> createEmailReturnPath(CreateEmailReturnPathRequest request) {
        return Mono.create(sink -> this.client.createEmailReturnPath(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSenderResponse> createSender(CreateSenderRequest request) {
        return Mono.create(sink -> this.client.createSender(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSuppressionResponse> createSuppression(CreateSuppressionRequest request) {
        return Mono.create(sink -> this.client.createSuppression(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDkimResponse> deleteDkim(DeleteDkimRequest request) {
        return Mono.create(sink -> this.client.deleteDkim(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteEmailDomainResponse> deleteEmailDomain(DeleteEmailDomainRequest request) {
        return Mono.create(sink -> this.client.deleteEmailDomain(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteEmailReturnPathResponse> deleteEmailReturnPath(DeleteEmailReturnPathRequest request) {
        return Mono.create(sink -> this.client.deleteEmailReturnPath(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSenderResponse> deleteSender(DeleteSenderRequest request) {
        return Mono.create(sink -> this.client.deleteSender(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSuppressionResponse> deleteSuppression(DeleteSuppressionRequest request) {
        return Mono.create(sink -> this.client.deleteSuppression(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDkimResponse> getDkim(GetDkimRequest request) {
        return Mono.create(sink -> this.client.getDkim(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEmailConfigurationResponse> getEmailConfiguration(GetEmailConfigurationRequest request) {
        return Mono.create(sink -> this.client.getEmailConfiguration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEmailDomainResponse> getEmailDomain(GetEmailDomainRequest request) {
        return Mono.create(sink -> this.client.getEmailDomain(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEmailReturnPathResponse> getEmailReturnPath(GetEmailReturnPathRequest request) {
        return Mono.create(sink -> this.client.getEmailReturnPath(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSenderResponse> getSender(GetSenderRequest request) {
        return Mono.create(sink -> this.client.getSender(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSuppressionResponse> getSuppression(GetSuppressionRequest request) {
        return Mono.create(sink -> this.client.getSuppression(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDkimsResponse> listDkims(ListDkimsRequest request) {
        return Mono.create(sink -> this.client.listDkims(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEmailDomainsResponse> listEmailDomains(ListEmailDomainsRequest request) {
        return Mono.create(sink -> this.client.listEmailDomains(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEmailReturnPathsResponse> listEmailReturnPaths(ListEmailReturnPathsRequest request) {
        return Mono.create(sink -> this.client.listEmailReturnPaths(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSendersResponse> listSenders(ListSendersRequest request) {
        return Mono.create(sink -> this.client.listSenders(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSuppressionsResponse> listSuppressions(ListSuppressionsRequest request) {
        return Mono.create(sink -> this.client.listSuppressions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDkimResponse> updateDkim(UpdateDkimRequest request) {
        return Mono.create(sink -> this.client.updateDkim(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateEmailDomainResponse> updateEmailDomain(UpdateEmailDomainRequest request) {
        return Mono.create(sink -> this.client.updateEmailDomain(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateEmailReturnPathResponse> updateEmailReturnPath(UpdateEmailReturnPathRequest request) {
        return Mono.create(sink -> this.client.updateEmailReturnPath(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSenderResponse> updateSender(UpdateSenderRequest request) {
        return Mono.create(sink -> this.client.updateSender(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

