/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.events;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.events.EventsAsyncClient;
import com.oracle.bmc.events.requests.ChangeRuleCompartmentRequest;
import com.oracle.bmc.events.requests.CreateRuleRequest;
import com.oracle.bmc.events.requests.DeleteRuleRequest;
import com.oracle.bmc.events.requests.GetRuleRequest;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.requests.UpdateRuleRequest;
import com.oracle.bmc.events.responses.ChangeRuleCompartmentResponse;
import com.oracle.bmc.events.responses.CreateRuleResponse;
import com.oracle.bmc.events.responses.DeleteRuleResponse;
import com.oracle.bmc.events.responses.GetRuleResponse;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.events.responses.UpdateRuleResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={EventsAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EventsReactorClient {
    EventsAsyncClient client;

    EventsReactorClient(EventsAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeRuleCompartmentResponse> changeRuleCompartment(ChangeRuleCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeRuleCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateRuleResponse> createRule(CreateRuleRequest request) {
        return Mono.create(sink -> this.client.createRule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRuleResponse> deleteRule(DeleteRuleRequest request) {
        return Mono.create(sink -> this.client.deleteRule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRuleResponse> getRule(GetRuleRequest request) {
        return Mono.create(sink -> this.client.getRule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRulesResponse> listRules(ListRulesRequest request) {
        return Mono.create(sink -> this.client.listRules(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRuleResponse> updateRule(UpdateRuleRequest request) {
        return Mono.create(sink -> this.client.updateRule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

