/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.functions;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.functions.FunctionsInvokeAsyncClient;
import com.oracle.bmc.functions.requests.InvokeFunctionRequest;
import com.oracle.bmc.functions.responses.InvokeFunctionResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={FunctionsInvokeAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class FunctionsInvokeReactorClient {
    FunctionsInvokeAsyncClient client;

    FunctionsInvokeReactorClient(FunctionsInvokeAsyncClient client) {
        this.client = client;
    }

    public Mono<InvokeFunctionResponse> invokeFunction(InvokeFunctionRequest request) {
        return Mono.create(sink -> this.client.invokeFunction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

