/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.ChannelsAsyncClient;
import com.oracle.bmc.mysql.requests.CreateChannelRequest;
import com.oracle.bmc.mysql.requests.DeleteChannelRequest;
import com.oracle.bmc.mysql.requests.GetChannelRequest;
import com.oracle.bmc.mysql.requests.ListChannelsRequest;
import com.oracle.bmc.mysql.requests.ResetChannelRequest;
import com.oracle.bmc.mysql.requests.ResumeChannelRequest;
import com.oracle.bmc.mysql.requests.UpdateChannelRequest;
import com.oracle.bmc.mysql.responses.CreateChannelResponse;
import com.oracle.bmc.mysql.responses.DeleteChannelResponse;
import com.oracle.bmc.mysql.responses.GetChannelResponse;
import com.oracle.bmc.mysql.responses.ListChannelsResponse;
import com.oracle.bmc.mysql.responses.ResetChannelResponse;
import com.oracle.bmc.mysql.responses.ResumeChannelResponse;
import com.oracle.bmc.mysql.responses.UpdateChannelResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ChannelsAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ChannelsReactorClient {
    ChannelsAsyncClient client;

    ChannelsReactorClient(ChannelsAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateChannelResponse> createChannel(CreateChannelRequest request) {
        return Mono.create(sink -> this.client.createChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteChannelResponse> deleteChannel(DeleteChannelRequest request) {
        return Mono.create(sink -> this.client.deleteChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetChannelResponse> getChannel(GetChannelRequest request) {
        return Mono.create(sink -> this.client.getChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListChannelsResponse> listChannels(ListChannelsRequest request) {
        return Mono.create(sink -> this.client.listChannels(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ResetChannelResponse> resetChannel(ResetChannelRequest request) {
        return Mono.create(sink -> this.client.resetChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ResumeChannelResponse> resumeChannel(ResumeChannelRequest request) {
        return Mono.create(sink -> this.client.resumeChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateChannelResponse> updateChannel(UpdateChannelRequest request) {
        return Mono.create(sink -> this.client.updateChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

