/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.DbBackupsAsyncClient;
import com.oracle.bmc.mysql.requests.ChangeBackupCompartmentRequest;
import com.oracle.bmc.mysql.requests.CreateBackupRequest;
import com.oracle.bmc.mysql.requests.DeleteBackupRequest;
import com.oracle.bmc.mysql.requests.GetBackupRequest;
import com.oracle.bmc.mysql.requests.ListBackupsRequest;
import com.oracle.bmc.mysql.requests.UpdateBackupRequest;
import com.oracle.bmc.mysql.responses.ChangeBackupCompartmentResponse;
import com.oracle.bmc.mysql.responses.CreateBackupResponse;
import com.oracle.bmc.mysql.responses.DeleteBackupResponse;
import com.oracle.bmc.mysql.responses.GetBackupResponse;
import com.oracle.bmc.mysql.responses.ListBackupsResponse;
import com.oracle.bmc.mysql.responses.UpdateBackupResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DbBackupsAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DbBackupsReactorClient {
    DbBackupsAsyncClient client;

    DbBackupsReactorClient(DbBackupsAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeBackupCompartmentResponse> changeBackupCompartment(ChangeBackupCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeBackupCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateBackupResponse> createBackup(CreateBackupRequest request) {
        return Mono.create(sink -> this.client.createBackup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteBackupResponse> deleteBackup(DeleteBackupRequest request) {
        return Mono.create(sink -> this.client.deleteBackup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetBackupResponse> getBackup(GetBackupRequest request) {
        return Mono.create(sink -> this.client.getBackup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListBackupsResponse> listBackups(ListBackupsRequest request) {
        return Mono.create(sink -> this.client.listBackups(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateBackupResponse> updateBackup(UpdateBackupRequest request) {
        return Mono.create(sink -> this.client.updateBackup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

