/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.ReplicasAsyncClient;
import com.oracle.bmc.mysql.requests.CreateReplicaRequest;
import com.oracle.bmc.mysql.requests.DeleteReplicaRequest;
import com.oracle.bmc.mysql.requests.GetReplicaRequest;
import com.oracle.bmc.mysql.requests.ListReplicasRequest;
import com.oracle.bmc.mysql.requests.UpdateReplicaRequest;
import com.oracle.bmc.mysql.responses.CreateReplicaResponse;
import com.oracle.bmc.mysql.responses.DeleteReplicaResponse;
import com.oracle.bmc.mysql.responses.GetReplicaResponse;
import com.oracle.bmc.mysql.responses.ListReplicasResponse;
import com.oracle.bmc.mysql.responses.UpdateReplicaResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ReplicasAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ReplicasRxClient {
    ReplicasAsyncClient client;

    ReplicasRxClient(ReplicasAsyncClient client) {
        this.client = client;
    }

    public Single<CreateReplicaResponse> createReplica(CreateReplicaRequest request) {
        return Single.create(emitter -> this.client.createReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteReplicaResponse> deleteReplica(DeleteReplicaRequest request) {
        return Single.create(emitter -> this.client.deleteReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetReplicaResponse> getReplica(GetReplicaRequest request) {
        return Single.create(emitter -> this.client.getReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListReplicasResponse> listReplicas(ListReplicasRequest request) {
        return Single.create(emitter -> this.client.listReplicas(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateReplicaResponse> updateReplica(UpdateReplicaRequest request) {
        return Single.create(emitter -> this.client.updateReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

