/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.nosql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.nosql.NosqlAsyncClient;
import com.oracle.bmc.nosql.requests.ChangeTableCompartmentRequest;
import com.oracle.bmc.nosql.requests.CreateIndexRequest;
import com.oracle.bmc.nosql.requests.CreateReplicaRequest;
import com.oracle.bmc.nosql.requests.CreateTableRequest;
import com.oracle.bmc.nosql.requests.DeleteIndexRequest;
import com.oracle.bmc.nosql.requests.DeleteReplicaRequest;
import com.oracle.bmc.nosql.requests.DeleteRowRequest;
import com.oracle.bmc.nosql.requests.DeleteTableRequest;
import com.oracle.bmc.nosql.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.nosql.requests.GetIndexRequest;
import com.oracle.bmc.nosql.requests.GetRowRequest;
import com.oracle.bmc.nosql.requests.GetTableRequest;
import com.oracle.bmc.nosql.requests.GetWorkRequestRequest;
import com.oracle.bmc.nosql.requests.ListIndexesRequest;
import com.oracle.bmc.nosql.requests.ListTableUsageRequest;
import com.oracle.bmc.nosql.requests.ListTablesRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.nosql.requests.PrepareStatementRequest;
import com.oracle.bmc.nosql.requests.QueryRequest;
import com.oracle.bmc.nosql.requests.SummarizeStatementRequest;
import com.oracle.bmc.nosql.requests.UpdateRowRequest;
import com.oracle.bmc.nosql.requests.UpdateTableRequest;
import com.oracle.bmc.nosql.responses.ChangeTableCompartmentResponse;
import com.oracle.bmc.nosql.responses.CreateIndexResponse;
import com.oracle.bmc.nosql.responses.CreateReplicaResponse;
import com.oracle.bmc.nosql.responses.CreateTableResponse;
import com.oracle.bmc.nosql.responses.DeleteIndexResponse;
import com.oracle.bmc.nosql.responses.DeleteReplicaResponse;
import com.oracle.bmc.nosql.responses.DeleteRowResponse;
import com.oracle.bmc.nosql.responses.DeleteTableResponse;
import com.oracle.bmc.nosql.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.nosql.responses.GetIndexResponse;
import com.oracle.bmc.nosql.responses.GetRowResponse;
import com.oracle.bmc.nosql.responses.GetTableResponse;
import com.oracle.bmc.nosql.responses.GetWorkRequestResponse;
import com.oracle.bmc.nosql.responses.ListIndexesResponse;
import com.oracle.bmc.nosql.responses.ListTableUsageResponse;
import com.oracle.bmc.nosql.responses.ListTablesResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.nosql.responses.PrepareStatementResponse;
import com.oracle.bmc.nosql.responses.QueryResponse;
import com.oracle.bmc.nosql.responses.SummarizeStatementResponse;
import com.oracle.bmc.nosql.responses.UpdateRowResponse;
import com.oracle.bmc.nosql.responses.UpdateTableResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={NosqlAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class NosqlReactorClient {
    NosqlAsyncClient client;

    NosqlReactorClient(NosqlAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeTableCompartmentResponse> changeTableCompartment(ChangeTableCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeTableCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateIndexResponse> createIndex(CreateIndexRequest request) {
        return Mono.create(sink -> this.client.createIndex(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateReplicaResponse> createReplica(CreateReplicaRequest request) {
        return Mono.create(sink -> this.client.createReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateTableResponse> createTable(CreateTableRequest request) {
        return Mono.create(sink -> this.client.createTable(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteIndexResponse> deleteIndex(DeleteIndexRequest request) {
        return Mono.create(sink -> this.client.deleteIndex(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteReplicaResponse> deleteReplica(DeleteReplicaRequest request) {
        return Mono.create(sink -> this.client.deleteReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRowResponse> deleteRow(DeleteRowRequest request) {
        return Mono.create(sink -> this.client.deleteRow(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteTableResponse> deleteTable(DeleteTableRequest request) {
        return Mono.create(sink -> this.client.deleteTable(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request) {
        return Mono.create(sink -> this.client.deleteWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetIndexResponse> getIndex(GetIndexRequest request) {
        return Mono.create(sink -> this.client.getIndex(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRowResponse> getRow(GetRowRequest request) {
        return Mono.create(sink -> this.client.getRow(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetTableResponse> getTable(GetTableRequest request) {
        return Mono.create(sink -> this.client.getTable(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListIndexesResponse> listIndexes(ListIndexesRequest request) {
        return Mono.create(sink -> this.client.listIndexes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListTableUsageResponse> listTableUsage(ListTableUsageRequest request) {
        return Mono.create(sink -> this.client.listTableUsage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListTablesResponse> listTables(ListTablesRequest request) {
        return Mono.create(sink -> this.client.listTables(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<PrepareStatementResponse> prepareStatement(PrepareStatementRequest request) {
        return Mono.create(sink -> this.client.prepareStatement(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<QueryResponse> query(QueryRequest request) {
        return Mono.create(sink -> this.client.query(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SummarizeStatementResponse> summarizeStatement(SummarizeStatementRequest request) {
        return Mono.create(sink -> this.client.summarizeStatement(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRowResponse> updateRow(UpdateRowRequest request) {
        return Mono.create(sink -> this.client.updateRow(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateTableResponse> updateTable(UpdateTableRequest request) {
        return Mono.create(sink -> this.client.updateTable(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

