/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.nosql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.nosql.NosqlAsyncClient;
import com.oracle.bmc.nosql.requests.ChangeTableCompartmentRequest;
import com.oracle.bmc.nosql.requests.CreateIndexRequest;
import com.oracle.bmc.nosql.requests.CreateReplicaRequest;
import com.oracle.bmc.nosql.requests.CreateTableRequest;
import com.oracle.bmc.nosql.requests.DeleteIndexRequest;
import com.oracle.bmc.nosql.requests.DeleteReplicaRequest;
import com.oracle.bmc.nosql.requests.DeleteRowRequest;
import com.oracle.bmc.nosql.requests.DeleteTableRequest;
import com.oracle.bmc.nosql.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.nosql.requests.GetIndexRequest;
import com.oracle.bmc.nosql.requests.GetRowRequest;
import com.oracle.bmc.nosql.requests.GetTableRequest;
import com.oracle.bmc.nosql.requests.GetWorkRequestRequest;
import com.oracle.bmc.nosql.requests.ListIndexesRequest;
import com.oracle.bmc.nosql.requests.ListTableUsageRequest;
import com.oracle.bmc.nosql.requests.ListTablesRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.nosql.requests.PrepareStatementRequest;
import com.oracle.bmc.nosql.requests.QueryRequest;
import com.oracle.bmc.nosql.requests.SummarizeStatementRequest;
import com.oracle.bmc.nosql.requests.UpdateRowRequest;
import com.oracle.bmc.nosql.requests.UpdateTableRequest;
import com.oracle.bmc.nosql.responses.ChangeTableCompartmentResponse;
import com.oracle.bmc.nosql.responses.CreateIndexResponse;
import com.oracle.bmc.nosql.responses.CreateReplicaResponse;
import com.oracle.bmc.nosql.responses.CreateTableResponse;
import com.oracle.bmc.nosql.responses.DeleteIndexResponse;
import com.oracle.bmc.nosql.responses.DeleteReplicaResponse;
import com.oracle.bmc.nosql.responses.DeleteRowResponse;
import com.oracle.bmc.nosql.responses.DeleteTableResponse;
import com.oracle.bmc.nosql.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.nosql.responses.GetIndexResponse;
import com.oracle.bmc.nosql.responses.GetRowResponse;
import com.oracle.bmc.nosql.responses.GetTableResponse;
import com.oracle.bmc.nosql.responses.GetWorkRequestResponse;
import com.oracle.bmc.nosql.responses.ListIndexesResponse;
import com.oracle.bmc.nosql.responses.ListTableUsageResponse;
import com.oracle.bmc.nosql.responses.ListTablesResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.nosql.responses.PrepareStatementResponse;
import com.oracle.bmc.nosql.responses.QueryResponse;
import com.oracle.bmc.nosql.responses.SummarizeStatementResponse;
import com.oracle.bmc.nosql.responses.UpdateRowResponse;
import com.oracle.bmc.nosql.responses.UpdateTableResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={NosqlAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class NosqlRxClient {
    NosqlAsyncClient client;

    NosqlRxClient(NosqlAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeTableCompartmentResponse> changeTableCompartment(ChangeTableCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeTableCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateIndexResponse> createIndex(CreateIndexRequest request) {
        return Single.create(emitter -> this.client.createIndex(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateReplicaResponse> createReplica(CreateReplicaRequest request) {
        return Single.create(emitter -> this.client.createReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateTableResponse> createTable(CreateTableRequest request) {
        return Single.create(emitter -> this.client.createTable(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteIndexResponse> deleteIndex(DeleteIndexRequest request) {
        return Single.create(emitter -> this.client.deleteIndex(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteReplicaResponse> deleteReplica(DeleteReplicaRequest request) {
        return Single.create(emitter -> this.client.deleteReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteRowResponse> deleteRow(DeleteRowRequest request) {
        return Single.create(emitter -> this.client.deleteRow(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteTableResponse> deleteTable(DeleteTableRequest request) {
        return Single.create(emitter -> this.client.deleteTable(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request) {
        return Single.create(emitter -> this.client.deleteWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetIndexResponse> getIndex(GetIndexRequest request) {
        return Single.create(emitter -> this.client.getIndex(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRowResponse> getRow(GetRowRequest request) {
        return Single.create(emitter -> this.client.getRow(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTableResponse> getTable(GetTableRequest request) {
        return Single.create(emitter -> this.client.getTable(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIndexesResponse> listIndexes(ListIndexesRequest request) {
        return Single.create(emitter -> this.client.listIndexes(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListTableUsageResponse> listTableUsage(ListTableUsageRequest request) {
        return Single.create(emitter -> this.client.listTableUsage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListTablesResponse> listTables(ListTablesRequest request) {
        return Single.create(emitter -> this.client.listTables(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PrepareStatementResponse> prepareStatement(PrepareStatementRequest request) {
        return Single.create(emitter -> this.client.prepareStatement(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<QueryResponse> query(QueryRequest request) {
        return Single.create(emitter -> this.client.query(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeStatementResponse> summarizeStatement(SummarizeStatementRequest request) {
        return Single.create(emitter -> this.client.summarizeStatement(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateRowResponse> updateRow(UpdateRowRequest request) {
        return Single.create(emitter -> this.client.updateRow(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateTableResponse> updateTable(UpdateTableRequest request) {
        return Single.create(emitter -> this.client.updateTable(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

