/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.optimizer;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.optimizer.OptimizerAsyncClient;
import com.oracle.bmc.optimizer.requests.BulkApplyRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.CreateProfileRequest;
import com.oracle.bmc.optimizer.requests.DeleteProfileRequest;
import com.oracle.bmc.optimizer.requests.FilterResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.GetCategoryRequest;
import com.oracle.bmc.optimizer.requests.GetEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.GetProfileRequest;
import com.oracle.bmc.optimizer.requests.GetRecommendationRequest;
import com.oracle.bmc.optimizer.requests.GetResourceActionRequest;
import com.oracle.bmc.optimizer.requests.GetWorkRequestRequest;
import com.oracle.bmc.optimizer.requests.ListCategoriesRequest;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.requests.ListHistoriesRequest;
import com.oracle.bmc.optimizer.requests.ListProfileLevelsRequest;
import com.oracle.bmc.optimizer.requests.ListProfilesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationStrategiesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionQueryableFieldsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.optimizer.requests.UpdateEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.UpdateProfileRequest;
import com.oracle.bmc.optimizer.requests.UpdateRecommendationRequest;
import com.oracle.bmc.optimizer.requests.UpdateResourceActionRequest;
import com.oracle.bmc.optimizer.responses.BulkApplyRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.CreateProfileResponse;
import com.oracle.bmc.optimizer.responses.DeleteProfileResponse;
import com.oracle.bmc.optimizer.responses.FilterResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.GetCategoryResponse;
import com.oracle.bmc.optimizer.responses.GetEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.GetProfileResponse;
import com.oracle.bmc.optimizer.responses.GetRecommendationResponse;
import com.oracle.bmc.optimizer.responses.GetResourceActionResponse;
import com.oracle.bmc.optimizer.responses.GetWorkRequestResponse;
import com.oracle.bmc.optimizer.responses.ListCategoriesResponse;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.optimizer.responses.ListHistoriesResponse;
import com.oracle.bmc.optimizer.responses.ListProfileLevelsResponse;
import com.oracle.bmc.optimizer.responses.ListProfilesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationStrategiesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionQueryableFieldsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.optimizer.responses.UpdateEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.UpdateProfileResponse;
import com.oracle.bmc.optimizer.responses.UpdateRecommendationResponse;
import com.oracle.bmc.optimizer.responses.UpdateResourceActionResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OptimizerAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OptimizerReactorClient {
    OptimizerAsyncClient client;

    OptimizerReactorClient(OptimizerAsyncClient client) {
        this.client = client;
    }

    public Mono<BulkApplyRecommendationsResponse> bulkApplyRecommendations(BulkApplyRecommendationsRequest request) {
        return Mono.create(sink -> this.client.bulkApplyRecommendations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateProfileResponse> createProfile(CreateProfileRequest request) {
        return Mono.create(sink -> this.client.createProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteProfileResponse> deleteProfile(DeleteProfileRequest request) {
        return Mono.create(sink -> this.client.deleteProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<FilterResourceActionsResponse> filterResourceActions(FilterResourceActionsRequest request) {
        return Mono.create(sink -> this.client.filterResourceActions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetCategoryResponse> getCategory(GetCategoryRequest request) {
        return Mono.create(sink -> this.client.getCategory(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEnrollmentStatusResponse> getEnrollmentStatus(GetEnrollmentStatusRequest request) {
        return Mono.create(sink -> this.client.getEnrollmentStatus(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetProfileResponse> getProfile(GetProfileRequest request) {
        return Mono.create(sink -> this.client.getProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRecommendationResponse> getRecommendation(GetRecommendationRequest request) {
        return Mono.create(sink -> this.client.getRecommendation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetResourceActionResponse> getResourceAction(GetResourceActionRequest request) {
        return Mono.create(sink -> this.client.getResourceAction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListCategoriesResponse> listCategories(ListCategoriesRequest request) {
        return Mono.create(sink -> this.client.listCategories(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEnrollmentStatusesResponse> listEnrollmentStatuses(ListEnrollmentStatusesRequest request) {
        return Mono.create(sink -> this.client.listEnrollmentStatuses(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListHistoriesResponse> listHistories(ListHistoriesRequest request) {
        return Mono.create(sink -> this.client.listHistories(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListProfileLevelsResponse> listProfileLevels(ListProfileLevelsRequest request) {
        return Mono.create(sink -> this.client.listProfileLevels(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListProfilesResponse> listProfiles(ListProfilesRequest request) {
        return Mono.create(sink -> this.client.listProfiles(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRecommendationStrategiesResponse> listRecommendationStrategies(ListRecommendationStrategiesRequest request) {
        return Mono.create(sink -> this.client.listRecommendationStrategies(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRecommendationsResponse> listRecommendations(ListRecommendationsRequest request) {
        return Mono.create(sink -> this.client.listRecommendations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListResourceActionQueryableFieldsResponse> listResourceActionQueryableFields(ListResourceActionQueryableFieldsRequest request) {
        return Mono.create(sink -> this.client.listResourceActionQueryableFields(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListResourceActionsResponse> listResourceActions(ListResourceActionsRequest request) {
        return Mono.create(sink -> this.client.listResourceActions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateEnrollmentStatusResponse> updateEnrollmentStatus(UpdateEnrollmentStatusRequest request) {
        return Mono.create(sink -> this.client.updateEnrollmentStatus(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateProfileResponse> updateProfile(UpdateProfileRequest request) {
        return Mono.create(sink -> this.client.updateProfile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRecommendationResponse> updateRecommendation(UpdateRecommendationRequest request) {
        return Mono.create(sink -> this.client.updateRecommendation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateResourceActionResponse> updateResourceAction(UpdateResourceActionRequest request) {
        return Mono.create(sink -> this.client.updateResourceAction(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

