/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.queue;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.queue.QueueAsyncClient;
import com.oracle.bmc.queue.requests.DeleteMessageRequest;
import com.oracle.bmc.queue.requests.DeleteMessagesRequest;
import com.oracle.bmc.queue.requests.GetMessagesRequest;
import com.oracle.bmc.queue.requests.GetStatsRequest;
import com.oracle.bmc.queue.requests.ListChannelsRequest;
import com.oracle.bmc.queue.requests.PutMessagesRequest;
import com.oracle.bmc.queue.requests.UpdateMessageRequest;
import com.oracle.bmc.queue.requests.UpdateMessagesRequest;
import com.oracle.bmc.queue.responses.DeleteMessageResponse;
import com.oracle.bmc.queue.responses.DeleteMessagesResponse;
import com.oracle.bmc.queue.responses.GetMessagesResponse;
import com.oracle.bmc.queue.responses.GetStatsResponse;
import com.oracle.bmc.queue.responses.ListChannelsResponse;
import com.oracle.bmc.queue.responses.PutMessagesResponse;
import com.oracle.bmc.queue.responses.UpdateMessageResponse;
import com.oracle.bmc.queue.responses.UpdateMessagesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={QueueAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class QueueReactorClient {
    QueueAsyncClient client;

    QueueReactorClient(QueueAsyncClient client) {
        this.client = client;
    }

    public Mono<DeleteMessageResponse> deleteMessage(DeleteMessageRequest request) {
        return Mono.create(sink -> this.client.deleteMessage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteMessagesResponse> deleteMessages(DeleteMessagesRequest request) {
        return Mono.create(sink -> this.client.deleteMessages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMessagesResponse> getMessages(GetMessagesRequest request) {
        return Mono.create(sink -> this.client.getMessages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetStatsResponse> getStats(GetStatsRequest request) {
        return Mono.create(sink -> this.client.getStats(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListChannelsResponse> listChannels(ListChannelsRequest request) {
        return Mono.create(sink -> this.client.listChannels(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<PutMessagesResponse> putMessages(PutMessagesRequest request) {
        return Mono.create(sink -> this.client.putMessages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateMessageResponse> updateMessage(UpdateMessageRequest request) {
        return Mono.create(sink -> this.client.updateMessage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateMessagesResponse> updateMessages(UpdateMessagesRequest request) {
        return Mono.create(sink -> this.client.updateMessages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

