/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.redis;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.redis.RedisClusterAsyncClient;
import com.oracle.bmc.redis.requests.CancelWorkRequestRequest;
import com.oracle.bmc.redis.requests.ChangeRedisClusterCompartmentRequest;
import com.oracle.bmc.redis.requests.CreateRedisClusterRequest;
import com.oracle.bmc.redis.requests.DeleteRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetWorkRequestRequest;
import com.oracle.bmc.redis.requests.ListRedisClustersRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestsRequest;
import com.oracle.bmc.redis.requests.UpdateRedisClusterRequest;
import com.oracle.bmc.redis.responses.CancelWorkRequestResponse;
import com.oracle.bmc.redis.responses.ChangeRedisClusterCompartmentResponse;
import com.oracle.bmc.redis.responses.CreateRedisClusterResponse;
import com.oracle.bmc.redis.responses.DeleteRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetWorkRequestResponse;
import com.oracle.bmc.redis.responses.ListRedisClustersResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestsResponse;
import com.oracle.bmc.redis.responses.UpdateRedisClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={RedisClusterAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class RedisClusterReactorClient {
    RedisClusterAsyncClient client;

    RedisClusterReactorClient(RedisClusterAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeRedisClusterCompartmentResponse> changeRedisClusterCompartment(ChangeRedisClusterCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeRedisClusterCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateRedisClusterResponse> createRedisCluster(CreateRedisClusterRequest request) {
        return Mono.create(sink -> this.client.createRedisCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRedisClusterResponse> deleteRedisCluster(DeleteRedisClusterRequest request) {
        return Mono.create(sink -> this.client.deleteRedisCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRedisClusterResponse> getRedisCluster(GetRedisClusterRequest request) {
        return Mono.create(sink -> this.client.getRedisCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRedisClustersResponse> listRedisClusters(ListRedisClustersRequest request) {
        return Mono.create(sink -> this.client.listRedisClusters(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRedisClusterResponse> updateRedisCluster(UpdateRedisClusterRequest request) {
        return Mono.create(sink -> this.client.updateRedisCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

