/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.nativeimage;

import com.fnproject.fn.api.FnConfiguration;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Internal
final class OciFunctionFeature
implements Feature {
    private static final String UNIX_SOCKET_NATIVE = "com.fnproject.fn.runtime.ntv.UnixSocketNative";
    private static final String FN_HANDLER = "fn.handler";

    OciFunctionFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class c;
        String[] s;
        String handler;
        Class t = access.findClassByName(UNIX_SOCKET_NATIVE);
        if (t != null) {
            JNIRuntimeAccess.register((Class[])new Class[]{t});
            JNIRuntimeAccess.register((Executable[])t.getDeclaredMethods());
            RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{t});
        }
        if ((handler = System.getProperty(FN_HANDLER)) != null && (s = handler.split("::")).length == 2 && (c = access.findClassByName(s[0])) != null) {
            Method[] declaredMethods;
            RuntimeReflection.register((Class[])new Class[]{c});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{c});
            ReflectionUtils.findMethod((Class)c, (String)s[1], (Class[])new Class[0]).ifPresent(xva$0 -> RuntimeReflection.register((Executable[])new Executable[]{xva$0}));
            for (Method declaredMethod : declaredMethods = c.getDeclaredMethods()) {
                if (declaredMethod.getAnnotation(FnConfiguration.class) == null) continue;
                RuntimeReflection.register((Executable[])new Executable[]{declaredMethod});
            }
        }
    }
}

