/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.function.nativeimage;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fnproject.fn.api.FnConfiguration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@Internal
final class OciFunctionFeature
implements Feature {
    private static final String UNIX_SOCKET_NATIVE = "com.fnproject.fn.runtime.ntv.UnixSocketNative";
    private static final String FN_HANDLER = "fn.handler";

    OciFunctionFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class clbClass;
        Class c;
        String[] s;
        String handler;
        Class t = access.findClassByName(UNIX_SOCKET_NATIVE);
        if (t != null) {
            try {
                Class.forName("org.graalvm.nativeimage.hosted.RuntimeJNIAccess").getMethod("register", Class[].class).invoke(null, new Object[]{new Class[]{t}});
                Class.forName("org.graalvm.nativeimage.hosted.RuntimeJNIAccess").getMethod("register", Executable[].class).invoke(null, new Object[]{t.getDeclaredMethods()});
            }
            catch (ReflectiveOperationException e) {
                RuntimeJNIAccess.register((Class[])new Class[]{t});
                RuntimeJNIAccess.register((Executable[])t.getDeclaredMethods());
            }
            RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{t});
        }
        if ((handler = System.getProperty(FN_HANDLER)) != null && (s = handler.split("::")).length == 2 && (c = access.findClassByName(s[0])) != null) {
            Method[] declaredMethods;
            RuntimeReflection.register((Class[])new Class[]{c});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{c});
            ReflectionUtils.findMethodsByName((Class)c, (String)s[1]).forEach(method -> {
                Class<?>[] parameterTypes;
                RuntimeReflection.register((Executable[])new Executable[]{method});
                Class<?> returnType = method.getReturnType();
                if (returnType != Void.TYPE && !ClassUtils.isJavaBasicType(returnType)) {
                    this.registerForReflection(returnType);
                }
                for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                    if (ClassUtils.isJavaBasicType(parameterType)) continue;
                    this.registerForReflection(parameterType);
                }
            });
            for (Method declaredMethod : declaredMethods = c.getDeclaredMethods()) {
                if (declaredMethod.getAnnotation(FnConfiguration.class) == null) continue;
                RuntimeReflection.register((Executable[])new Executable[]{declaredMethod});
            }
        }
        if ((clbClass = access.findClassByName("org.glassfish.jersey.client.JerseyClientBuilder")) != null) {
            OciFunctionFeature.registerIfNecessary(clbClass);
        }
    }

    private void registerForReflection(Class<?> type) {
        Object[] types;
        JsonSubTypes subTypes;
        Class di;
        if (type.getAnnotation(Introspected.class) != null) {
            return;
        }
        OciFunctionFeature.checkDeserialize(type);
        JsonTypeInfo ti = type.getAnnotation(JsonTypeInfo.class);
        if (ti != null && (di = ti.defaultImpl()) != JsonTypeInfo.class) {
            OciFunctionFeature.registerIfNecessary(di);
        }
        if ((subTypes = type.getAnnotation(JsonSubTypes.class)) != null && ArrayUtils.isNotEmpty((Object[])(types = subTypes.value()))) {
            for (Object t : types) {
                Class v = t.value();
                OciFunctionFeature.registerIfNecessary(v);
            }
        }
    }

    private static void checkDeserialize(AnnotatedElement type) {
        JsonDeserialize deser = type.getAnnotation(JsonDeserialize.class);
        if (deser != null) {
            OciFunctionFeature.registerIfNecessary(deser.builder());
            OciFunctionFeature.registerIfNecessary(deser.as());
            OciFunctionFeature.registerIfNecessary(deser.contentAs());
            OciFunctionFeature.registerIfNecessary(deser.keyAs());
            OciFunctionFeature.registerIfNecessary(deser.using());
        }
    }

    private static void registerIfNecessary(Class<?> t) {
        if (t != Object.class && t != Void.class && !Modifier.isAbstract(t.getModifiers())) {
            OciFunctionFeature.registerAllForRuntimeReflectionAndReflectiveInstantiation(t);
        }
    }

    private static void registerAllForRuntimeReflectionAndReflectiveInstantiation(Class<?> clazz) {
        OciFunctionFeature.registerForRuntimeReflection(clazz);
        OciFunctionFeature.registerForReflectiveInstantiation(clazz);
        OciFunctionFeature.registerFieldsForRuntimeReflection(clazz);
        OciFunctionFeature.registerMethodsForRuntimeReflection(clazz);
        OciFunctionFeature.registerConstructorsForRuntimeReflection(clazz);
    }

    private static void registerAllForRuntimeReflection(Class<?> clazz) {
        OciFunctionFeature.registerForRuntimeReflection(clazz);
        OciFunctionFeature.registerFieldsForRuntimeReflection(clazz);
        OciFunctionFeature.registerMethodsForRuntimeReflection(clazz);
        OciFunctionFeature.registerConstructorsForRuntimeReflection(clazz);
    }

    private static void registerFieldsAndMethodsWithReflectiveAccess(Class<?> clazz) {
        OciFunctionFeature.registerForRuntimeReflectionAndReflectiveInstantiation(clazz);
        OciFunctionFeature.registerMethodsForRuntimeReflection(clazz);
        OciFunctionFeature.registerFieldsForRuntimeReflection(clazz);
    }

    private static void registerForRuntimeReflection(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
    }

    private static void registerForReflectiveInstantiation(Class<?> clazz) {
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
    }

    private static void registerForRuntimeReflectionAndReflectiveInstantiation(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
    }

    private static void registerMethodsForRuntimeReflection(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            OciFunctionFeature.checkDeserialize(method);
            RuntimeReflection.register((Executable[])new Executable[]{method});
        }
    }

    private static void registerFieldsForRuntimeReflection(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            OciFunctionFeature.checkDeserialize(field);
            RuntimeReflection.register((Field[])new Field[]{field});
        }
    }

    private static void registerConstructorsForRuntimeReflection(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            RuntimeReflection.register((Executable[])new Executable[]{constructor});
        }
    }
}

