/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.QueueFactory;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.util.Duration;
import com.oracle.bmc.loggingingestion.model.LogEntry;
import com.oracle.bmc.loggingingestion.model.LogEntryBatch;
import com.oracle.bmc.loggingingestion.model.PutLogsDetails;
import com.oracle.bmc.loggingingestion.requests.PutLogsRequest;
import io.micronaut.core.annotation.Internal;
import io.micronaut.oraclecloud.logging.OracleCloudLoggingClient;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@Internal
public final class OracleCloudAppender
extends AppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    private static final int DEFAULT_MAX_BATCH_SIZE = 128;
    private static final String SPEC_VERSION = "1.0";
    private static final long DEFAULT_PUBLISH_PERIOD = 100L;
    private final QueueFactory queueFactory = new QueueFactory();
    private final Duration eventDelayLimit = new Duration(100L);
    private final List<String> blackListLoggerName = new ArrayList<String>();
    private Encoder<ILoggingEvent> encoder;
    private Future<?> task;
    private BlockingDeque<ILoggingEvent> deque;
    private String logId;
    private String source;
    private String subject;
    private String type;
    private int queueSize = 128;
    private long publishPeriod = 100L;
    private int maxBatchSize = 128;
    private Appender<ILoggingEvent> emergencyAppender;
    private boolean configuredSuccessfully = false;

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public long getPublishPeriod() {
        return this.publishPeriod;
    }

    public void setPublishPeriod(long publishPeriod) {
        this.publishPeriod = publishPeriod;
    }

    public void addBlackListLoggerName(String blackListLoggerName) {
        this.blackListLoggerName.add(blackListLoggerName);
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.queueSize == 0) {
            this.addWarn("Queue size of zero is deprecated, use a size of one to indicate synchronous processing");
        }
        if (this.queueSize < 0) {
            this.addError("Queue size must be greater than zero");
            return;
        }
        if (this.publishPeriod <= 0L) {
            this.addError("Publish period must be greater than zero");
            return;
        }
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "].");
            return;
        }
        if (this.maxBatchSize <= 0) {
            this.addError("Max Batch size must be greater than zero");
            return;
        }
        if (this.logId == null) {
            this.addWarn("LogId is not specified in logback configuration it might be fetch from application configuration if available");
            return;
        }
        if (this.emergencyAppender != null && !this.emergencyAppender.isStarted()) {
            this.emergencyAppender.start();
        }
        this.deque = this.queueFactory.newLinkedBlockingDeque(this.queueSize);
        this.task = this.getContext().getScheduledExecutorService().scheduleAtFixedRate(() -> {
            try {
                this.dispatchEvents();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, 0L, this.publishPeriod, TimeUnit.MILLISECONDS);
        super.start();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.task.cancel(true);
        super.stop();
    }

    protected void append(ILoggingEvent eventObject) {
        if (eventObject == null || !this.isStarted() || this.blackListLoggerName.contains(eventObject.getLoggerName())) {
            return;
        }
        try {
            boolean inserted = this.deque.offer(eventObject, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!inserted) {
                this.addInfo("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded");
                if (this.emergencyAppender != null) {
                    this.emergencyAppender.doAppend((Object)eventObject);
                }
            }
        }
        catch (InterruptedException e) {
            this.addError("Interrupted while appending event to SocketAppender", e);
            Thread.currentThread().interrupt();
        }
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    private boolean tryToConfigure() {
        if (!OracleCloudLoggingClient.isReady()) {
            return false;
        }
        String host = OracleCloudLoggingClient.getHost();
        String appName = OracleCloudLoggingClient.getAppName();
        String logIdFromAppConfig = OracleCloudLoggingClient.getLogId();
        if (this.type == null) {
            this.type = String.format("%s.%s", host, appName);
        }
        if (this.source == null) {
            this.source = host;
        }
        if (this.subject == null) {
            this.subject = appName;
        }
        if (logIdFromAppConfig != null) {
            this.addInfo("Using logId from application configuration");
            this.logId = logIdFromAppConfig;
        }
        if (this.logId == null) {
            this.addError("LogId is null. Everything will be sent to emergency appender if set");
        }
        this.configuredSuccessfully = true;
        return true;
    }

    private void dispatchEvents() throws InterruptedException {
        if (!this.configuredSuccessfully && !this.tryToConfigure()) {
            return;
        }
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>(this.maxBatchSize);
        ArrayList<ILoggingEvent> iLoggingEvents = new ArrayList<ILoggingEvent>(this.maxBatchSize);
        while (!this.deque.isEmpty() && logEntries.size() < this.maxBatchSize) {
            ILoggingEvent event = this.deque.takeFirst();
            LogEntry inputLogEvent = LogEntry.builder().id(UUID.randomUUID().toString()).data(new String(this.encoder.encode((Object)event), StandardCharsets.UTF_8)).build();
            iLoggingEvents.add(event);
            logEntries.add(inputLogEvent);
        }
        if (!logEntries.isEmpty() && !this.sendLogsToOracleCloud(logEntries) && this.emergencyAppender != null) {
            iLoggingEvents.forEach(arg_0 -> this.emergencyAppender.doAppend(arg_0));
        }
    }

    private boolean sendLogsToOracleCloud(List<LogEntry> logEntries) {
        PutLogsDetails putLogsDetails = PutLogsDetails.builder().logEntryBatches(Collections.singletonList(LogEntryBatch.builder().source(this.source).subject(this.subject).type(this.type).defaultlogentrytime(new Date()).entries(logEntries).build())).specversion(SPEC_VERSION).build();
        PutLogsRequest putLogsRequest = PutLogsRequest.builder().putLogsDetails(putLogsDetails).logId(this.logId).build();
        try {
            if (OracleCloudLoggingClient.putLogs(putLogsRequest)) {
                return true;
            }
            this.addError("Sending log request failed");
        }
        catch (Exception e) {
            this.addError("Sending log request failed", e);
        }
        return false;
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        if (this.emergencyAppender == null) {
            this.emergencyAppender = newAppender;
        } else {
            this.addWarn("One and only one appender may be attached to " + ((Object)((Object)this)).getClass().getSimpleName());
            this.addWarn("Ignoring additional appender named [" + newAppender.getName() + "]");
        }
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        throw new UnsupportedOperationException("Don't know how to create iterator");
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        if (this.emergencyAppender != null && name != null && name.equals(this.emergencyAppender.getName())) {
            return this.emergencyAppender;
        }
        return null;
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.emergencyAppender == appender;
    }

    public void detachAndStopAllAppenders() {
        if (this.emergencyAppender != null) {
            this.emergencyAppender.stop();
            this.emergencyAppender = null;
        }
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        if (this.emergencyAppender == appender) {
            this.emergencyAppender = null;
            return true;
        }
        return false;
    }

    public boolean detachAppender(String name) {
        if (this.emergencyAppender != null && this.emergencyAppender.getName().equals(name)) {
            this.emergencyAppender = null;
            return true;
        }
        return false;
    }
}

