/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.logging;

import com.oracle.bmc.loggingingestion.Logging;
import com.oracle.bmc.loggingingestion.requests.PutLogsRequest;
import com.oracle.bmc.loggingingestion.responses.PutLogsResponse;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;

@Context
@Internal
@Singleton
@Requirements(value={@Requires(bean=Logging.class), @Requires(property="oci.logging.enabled", value="true", defaultValue="true")})
final class OracleCloudLoggingClient
implements ApplicationEventListener<ServerStartupEvent> {
    public static final String PREFIX = "oci.logging";
    public static final String ENABLED = "oci.logging.enabled";
    private static Logging logging;
    private static String host;
    private static String appName;
    private static String logId;
    private final Logging internalLogging;
    private final String internalAppName;
    private final String internalLogId;

    public OracleCloudLoggingClient(Logging logging, ApplicationConfiguration applicationConfiguration, @Nullable @Property(name="oci.logging.logId") String internalLogId) {
        this.internalLogging = logging;
        this.internalAppName = applicationConfiguration.getName().orElse("");
        this.internalLogId = internalLogId;
    }

    static synchronized boolean isReady() {
        return logging != null;
    }

    static synchronized String getHost() {
        return host;
    }

    static synchronized String getAppName() {
        return appName;
    }

    private static synchronized void setLogging(Logging logging, String host, String appName, String logId) {
        OracleCloudLoggingClient.logging = logging;
        OracleCloudLoggingClient.host = host;
        OracleCloudLoggingClient.appName = appName;
        OracleCloudLoggingClient.logId = logId;
    }

    static synchronized void destroy() throws Exception {
        logging.close();
        logging = null;
        host = null;
        appName = null;
    }

    static synchronized boolean putLogs(PutLogsRequest putLogsRequest) {
        if (logging != null) {
            PutLogsResponse putLogsResponse = logging.putLogs(putLogsRequest);
            return putLogsResponse.getOpcRequestId() != null;
        }
        return false;
    }

    public static synchronized String getLogId() {
        return logId;
    }

    @PreDestroy
    public void close() throws Exception {
        OracleCloudLoggingClient.destroy();
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        OracleCloudLoggingClient.setLogging(this.internalLogging, event.getSource().getHost(), this.internalAppName, this.internalLogId);
    }
}

