/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ailanguage;

import com.oracle.bmc.ailanguage.AIServiceLanguageAsyncClient;
import com.oracle.bmc.ailanguage.requests.DetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AIServiceLanguageAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AIServiceLanguageRxClient {
    AIServiceLanguageAsyncClient client;

    AIServiceLanguageRxClient(AIServiceLanguageAsyncClient client) {
        this.client = client;
    }

    public Single<DetectDominantLanguageResponse> detectDominantLanguage(DetectDominantLanguageRequest request) {
        return Single.create(emitter -> this.client.detectDominantLanguage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DetectLanguageEntitiesResponse> detectLanguageEntities(DetectLanguageEntitiesRequest request) {
        return Single.create(emitter -> this.client.detectLanguageEntities(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DetectLanguageKeyPhrasesResponse> detectLanguageKeyPhrases(DetectLanguageKeyPhrasesRequest request) {
        return Single.create(emitter -> this.client.detectLanguageKeyPhrases(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DetectLanguageSentimentsResponse> detectLanguageSentiments(DetectLanguageSentimentsRequest request) {
        return Single.create(emitter -> this.client.detectLanguageSentiments(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DetectLanguageTextClassificationResponse> detectLanguageTextClassification(DetectLanguageTextClassificationRequest request) {
        return Single.create(emitter -> this.client.detectLanguageTextClassification(request, new AsyncHandlerEmitter(emitter)));
    }
}

