/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apigateway;

import com.oracle.bmc.apigateway.ApiGatewayAsyncClient;
import com.oracle.bmc.apigateway.requests.ChangeApiCompartmentRequest;
import com.oracle.bmc.apigateway.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateApiRequest;
import com.oracle.bmc.apigateway.requests.CreateCertificateRequest;
import com.oracle.bmc.apigateway.requests.CreateSdkRequest;
import com.oracle.bmc.apigateway.requests.DeleteApiRequest;
import com.oracle.bmc.apigateway.requests.DeleteCertificateRequest;
import com.oracle.bmc.apigateway.requests.DeleteSdkRequest;
import com.oracle.bmc.apigateway.requests.GetApiContentRequest;
import com.oracle.bmc.apigateway.requests.GetApiDeploymentSpecificationRequest;
import com.oracle.bmc.apigateway.requests.GetApiRequest;
import com.oracle.bmc.apigateway.requests.GetApiValidationsRequest;
import com.oracle.bmc.apigateway.requests.GetCertificateRequest;
import com.oracle.bmc.apigateway.requests.GetSdkRequest;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.requests.ListSdkLanguageTypesRequest;
import com.oracle.bmc.apigateway.requests.ListSdksRequest;
import com.oracle.bmc.apigateway.requests.UpdateApiRequest;
import com.oracle.bmc.apigateway.requests.UpdateCertificateRequest;
import com.oracle.bmc.apigateway.requests.UpdateSdkRequest;
import com.oracle.bmc.apigateway.responses.ChangeApiCompartmentResponse;
import com.oracle.bmc.apigateway.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateApiResponse;
import com.oracle.bmc.apigateway.responses.CreateCertificateResponse;
import com.oracle.bmc.apigateway.responses.CreateSdkResponse;
import com.oracle.bmc.apigateway.responses.DeleteApiResponse;
import com.oracle.bmc.apigateway.responses.DeleteCertificateResponse;
import com.oracle.bmc.apigateway.responses.DeleteSdkResponse;
import com.oracle.bmc.apigateway.responses.GetApiContentResponse;
import com.oracle.bmc.apigateway.responses.GetApiDeploymentSpecificationResponse;
import com.oracle.bmc.apigateway.responses.GetApiResponse;
import com.oracle.bmc.apigateway.responses.GetApiValidationsResponse;
import com.oracle.bmc.apigateway.responses.GetCertificateResponse;
import com.oracle.bmc.apigateway.responses.GetSdkResponse;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.apigateway.responses.ListSdkLanguageTypesResponse;
import com.oracle.bmc.apigateway.responses.ListSdksResponse;
import com.oracle.bmc.apigateway.responses.UpdateApiResponse;
import com.oracle.bmc.apigateway.responses.UpdateCertificateResponse;
import com.oracle.bmc.apigateway.responses.UpdateSdkResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ApiGatewayAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ApiGatewayRxClient {
    ApiGatewayAsyncClient client;

    ApiGatewayRxClient(ApiGatewayAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeApiCompartmentResponse> changeApiCompartment(ChangeApiCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeApiCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeCertificateCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateApiResponse> createApi(CreateApiRequest request) {
        return Single.create(emitter -> this.client.createApi(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateCertificateResponse> createCertificate(CreateCertificateRequest request) {
        return Single.create(emitter -> this.client.createCertificate(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSdkResponse> createSdk(CreateSdkRequest request) {
        return Single.create(emitter -> this.client.createSdk(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteApiResponse> deleteApi(DeleteApiRequest request) {
        return Single.create(emitter -> this.client.deleteApi(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request) {
        return Single.create(emitter -> this.client.deleteCertificate(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSdkResponse> deleteSdk(DeleteSdkRequest request) {
        return Single.create(emitter -> this.client.deleteSdk(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApiResponse> getApi(GetApiRequest request) {
        return Single.create(emitter -> this.client.getApi(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApiContentResponse> getApiContent(GetApiContentRequest request) {
        return Single.create(emitter -> this.client.getApiContent(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApiDeploymentSpecificationResponse> getApiDeploymentSpecification(GetApiDeploymentSpecificationRequest request) {
        return Single.create(emitter -> this.client.getApiDeploymentSpecification(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApiValidationsResponse> getApiValidations(GetApiValidationsRequest request) {
        return Single.create(emitter -> this.client.getApiValidations(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetCertificateResponse> getCertificate(GetCertificateRequest request) {
        return Single.create(emitter -> this.client.getCertificate(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSdkResponse> getSdk(GetSdkRequest request) {
        return Single.create(emitter -> this.client.getSdk(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListApisResponse> listApis(ListApisRequest request) {
        return Single.create(emitter -> this.client.listApis(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListCertificatesResponse> listCertificates(ListCertificatesRequest request) {
        return Single.create(emitter -> this.client.listCertificates(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSdkLanguageTypesResponse> listSdkLanguageTypes(ListSdkLanguageTypesRequest request) {
        return Single.create(emitter -> this.client.listSdkLanguageTypes(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSdksResponse> listSdks(ListSdksRequest request) {
        return Single.create(emitter -> this.client.listSdks(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateApiResponse> updateApi(UpdateApiRequest request) {
        return Single.create(emitter -> this.client.updateApi(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request) {
        return Single.create(emitter -> this.client.updateCertificate(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSdkResponse> updateSdk(UpdateSdkRequest request) {
        return Single.create(emitter -> this.client.updateSdk(request, new AsyncHandlerEmitter(emitter)));
    }
}

