/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.applicationmigration;

import com.oracle.bmc.applicationmigration.ApplicationMigrationAsyncClient;
import com.oracle.bmc.applicationmigration.requests.CancelWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeSourceCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.CreateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.CreateSourceRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.GetSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ListMigrationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourceApplicationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourcesRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.applicationmigration.requests.MigrateApplicationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateSourceRequest;
import com.oracle.bmc.applicationmigration.responses.CancelWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeSourceCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.CreateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.CreateSourceResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.GetSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ListMigrationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourceApplicationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourcesResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.applicationmigration.responses.MigrateApplicationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateSourceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ApplicationMigrationAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ApplicationMigrationRxClient {
    ApplicationMigrationAsyncClient client;

    ApplicationMigrationRxClient(ApplicationMigrationAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeMigrationCompartmentResponse> changeMigrationCompartment(ChangeMigrationCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeMigrationCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeSourceCompartmentResponse> changeSourceCompartment(ChangeSourceCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeSourceCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateMigrationResponse> createMigration(CreateMigrationRequest request) {
        return Single.create(emitter -> this.client.createMigration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSourceResponse> createSource(CreateSourceRequest request) {
        return Single.create(emitter -> this.client.createSource(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteMigrationResponse> deleteMigration(DeleteMigrationRequest request) {
        return Single.create(emitter -> this.client.deleteMigration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSourceResponse> deleteSource(DeleteSourceRequest request) {
        return Single.create(emitter -> this.client.deleteSource(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetMigrationResponse> getMigration(GetMigrationRequest request) {
        return Single.create(emitter -> this.client.getMigration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSourceResponse> getSource(GetSourceRequest request) {
        return Single.create(emitter -> this.client.getSource(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListMigrationsResponse> listMigrations(ListMigrationsRequest request) {
        return Single.create(emitter -> this.client.listMigrations(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSourceApplicationsResponse> listSourceApplications(ListSourceApplicationsRequest request) {
        return Single.create(emitter -> this.client.listSourceApplications(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSourcesResponse> listSources(ListSourcesRequest request) {
        return Single.create(emitter -> this.client.listSources(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<MigrateApplicationResponse> migrateApplication(MigrateApplicationRequest request) {
        return Single.create(emitter -> this.client.migrateApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateMigrationResponse> updateMigration(UpdateMigrationRequest request) {
        return Single.create(emitter -> this.client.updateMigration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSourceResponse> updateSource(UpdateSourceRequest request) {
        return Single.create(emitter -> this.client.updateSource(request, new AsyncHandlerEmitter(emitter)));
    }
}

