/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.bastion;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.bastion.BastionAsyncClient;
import com.oracle.bmc.bastion.requests.ChangeBastionCompartmentRequest;
import com.oracle.bmc.bastion.requests.CreateBastionRequest;
import com.oracle.bmc.bastion.requests.CreateSessionRequest;
import com.oracle.bmc.bastion.requests.DeleteBastionRequest;
import com.oracle.bmc.bastion.requests.DeleteSessionRequest;
import com.oracle.bmc.bastion.requests.GetBastionRequest;
import com.oracle.bmc.bastion.requests.GetSessionRequest;
import com.oracle.bmc.bastion.requests.GetWorkRequestRequest;
import com.oracle.bmc.bastion.requests.ListBastionsRequest;
import com.oracle.bmc.bastion.requests.ListSessionsRequest;
import com.oracle.bmc.bastion.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bastion.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bastion.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bastion.requests.UpdateBastionRequest;
import com.oracle.bmc.bastion.requests.UpdateSessionRequest;
import com.oracle.bmc.bastion.responses.ChangeBastionCompartmentResponse;
import com.oracle.bmc.bastion.responses.CreateBastionResponse;
import com.oracle.bmc.bastion.responses.CreateSessionResponse;
import com.oracle.bmc.bastion.responses.DeleteBastionResponse;
import com.oracle.bmc.bastion.responses.DeleteSessionResponse;
import com.oracle.bmc.bastion.responses.GetBastionResponse;
import com.oracle.bmc.bastion.responses.GetSessionResponse;
import com.oracle.bmc.bastion.responses.GetWorkRequestResponse;
import com.oracle.bmc.bastion.responses.ListBastionsResponse;
import com.oracle.bmc.bastion.responses.ListSessionsResponse;
import com.oracle.bmc.bastion.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bastion.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bastion.responses.ListWorkRequestsResponse;
import com.oracle.bmc.bastion.responses.UpdateBastionResponse;
import com.oracle.bmc.bastion.responses.UpdateSessionResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={BastionAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class BastionRxClient {
    BastionAsyncClient client;

    BastionRxClient(BastionAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeBastionCompartmentResponse> changeBastionCompartment(ChangeBastionCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeBastionCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateBastionResponse> createBastion(CreateBastionRequest request) {
        return Single.create(emitter -> this.client.createBastion(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSessionResponse> createSession(CreateSessionRequest request) {
        return Single.create(emitter -> this.client.createSession(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteBastionResponse> deleteBastion(DeleteBastionRequest request) {
        return Single.create(emitter -> this.client.deleteBastion(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSessionResponse> deleteSession(DeleteSessionRequest request) {
        return Single.create(emitter -> this.client.deleteSession(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetBastionResponse> getBastion(GetBastionRequest request) {
        return Single.create(emitter -> this.client.getBastion(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSessionResponse> getSession(GetSessionRequest request) {
        return Single.create(emitter -> this.client.getSession(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListBastionsResponse> listBastions(ListBastionsRequest request) {
        return Single.create(emitter -> this.client.listBastions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSessionsResponse> listSessions(ListSessionsRequest request) {
        return Single.create(emitter -> this.client.listSessions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateBastionResponse> updateBastion(UpdateBastionRequest request) {
        return Single.create(emitter -> this.client.updateBastion(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSessionResponse> updateSession(UpdateSessionRequest request) {
        return Single.create(emitter -> this.client.updateSession(request, new AsyncHandlerEmitter(emitter)));
    }
}

