/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.blockchain;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.blockchain.BlockchainPlatformAsyncClient;
import com.oracle.bmc.blockchain.requests.ChangeBlockchainPlatformCompartmentRequest;
import com.oracle.bmc.blockchain.requests.CreateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.CreateOsnRequest;
import com.oracle.bmc.blockchain.requests.CreatePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.DeleteOsnRequest;
import com.oracle.bmc.blockchain.requests.DeletePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.GetBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.requests.GetPeerRequest;
import com.oracle.bmc.blockchain.requests.GetWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformsRequest;
import com.oracle.bmc.blockchain.requests.ListOsnsRequest;
import com.oracle.bmc.blockchain.requests.ListPeersRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestsRequest;
import com.oracle.bmc.blockchain.requests.PreviewScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.ScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StartBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StopBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateOsnRequest;
import com.oracle.bmc.blockchain.requests.UpdatePeerRequest;
import com.oracle.bmc.blockchain.responses.ChangeBlockchainPlatformCompartmentResponse;
import com.oracle.bmc.blockchain.responses.CreateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.CreateOsnResponse;
import com.oracle.bmc.blockchain.responses.CreatePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.DeleteOsnResponse;
import com.oracle.bmc.blockchain.responses.DeletePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.GetBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.blockchain.responses.GetPeerResponse;
import com.oracle.bmc.blockchain.responses.GetWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformsResponse;
import com.oracle.bmc.blockchain.responses.ListOsnsResponse;
import com.oracle.bmc.blockchain.responses.ListPeersResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestsResponse;
import com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.ScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StartBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StopBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateOsnResponse;
import com.oracle.bmc.blockchain.responses.UpdatePeerResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={BlockchainPlatformAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class BlockchainPlatformRxClient {
    BlockchainPlatformAsyncClient client;

    BlockchainPlatformRxClient(BlockchainPlatformAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeBlockchainPlatformCompartmentResponse> changeBlockchainPlatformCompartment(ChangeBlockchainPlatformCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeBlockchainPlatformCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateBlockchainPlatformResponse> createBlockchainPlatform(CreateBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.createBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateOsnResponse> createOsn(CreateOsnRequest request) {
        return Single.create(emitter -> this.client.createOsn(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreatePeerResponse> createPeer(CreatePeerRequest request) {
        return Single.create(emitter -> this.client.createPeer(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteBlockchainPlatformResponse> deleteBlockchainPlatform(DeleteBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.deleteBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteOsnResponse> deleteOsn(DeleteOsnRequest request) {
        return Single.create(emitter -> this.client.deleteOsn(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeletePeerResponse> deletePeer(DeletePeerRequest request) {
        return Single.create(emitter -> this.client.deletePeer(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request) {
        return Single.create(emitter -> this.client.deleteWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetBlockchainPlatformResponse> getBlockchainPlatform(GetBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.getBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOsnResponse> getOsn(GetOsnRequest request) {
        return Single.create(emitter -> this.client.getOsn(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetPeerResponse> getPeer(GetPeerRequest request) {
        return Single.create(emitter -> this.client.getPeer(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListBlockchainPlatformsResponse> listBlockchainPlatforms(ListBlockchainPlatformsRequest request) {
        return Single.create(emitter -> this.client.listBlockchainPlatforms(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOsnsResponse> listOsns(ListOsnsRequest request) {
        return Single.create(emitter -> this.client.listOsns(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListPeersResponse> listPeers(ListPeersRequest request) {
        return Single.create(emitter -> this.client.listPeers(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<PreviewScaleBlockchainPlatformResponse> previewScaleBlockchainPlatform(PreviewScaleBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.previewScaleBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScaleBlockchainPlatformResponse> scaleBlockchainPlatform(ScaleBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.scaleBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<StartBlockchainPlatformResponse> startBlockchainPlatform(StartBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.startBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<StopBlockchainPlatformResponse> stopBlockchainPlatform(StopBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.stopBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateBlockchainPlatformResponse> updateBlockchainPlatform(UpdateBlockchainPlatformRequest request) {
        return Single.create(emitter -> this.client.updateBlockchainPlatform(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateOsnResponse> updateOsn(UpdateOsnRequest request) {
        return Single.create(emitter -> this.client.updateOsn(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdatePeerResponse> updatePeer(UpdatePeerRequest request) {
        return Single.create(emitter -> this.client.updatePeer(request, new AsyncHandlerEmitter(emitter)));
    }
}

