/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.computeinstanceagent;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgentAsyncClient;
import com.oracle.bmc.computeinstanceagent.requests.CancelInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.CreateInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandExecutionRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandExecutionsRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandsRequest;
import com.oracle.bmc.computeinstanceagent.responses.CancelInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.CreateInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandExecutionsResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ComputeInstanceAgentAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ComputeInstanceAgentRxClient {
    ComputeInstanceAgentAsyncClient client;

    ComputeInstanceAgentRxClient(ComputeInstanceAgentAsyncClient client) {
        this.client = client;
    }

    public Single<CancelInstanceAgentCommandResponse> cancelInstanceAgentCommand(CancelInstanceAgentCommandRequest request) {
        return Single.create(emitter -> this.client.cancelInstanceAgentCommand(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateInstanceAgentCommandResponse> createInstanceAgentCommand(CreateInstanceAgentCommandRequest request) {
        return Single.create(emitter -> this.client.createInstanceAgentCommand(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetInstanceAgentCommandResponse> getInstanceAgentCommand(GetInstanceAgentCommandRequest request) {
        return Single.create(emitter -> this.client.getInstanceAgentCommand(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetInstanceAgentCommandExecutionResponse> getInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request) {
        return Single.create(emitter -> this.client.getInstanceAgentCommandExecution(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListInstanceAgentCommandExecutionsResponse> listInstanceAgentCommandExecutions(ListInstanceAgentCommandExecutionsRequest request) {
        return Single.create(emitter -> this.client.listInstanceAgentCommandExecutions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListInstanceAgentCommandsResponse> listInstanceAgentCommands(ListInstanceAgentCommandsRequest request) {
        return Single.create(emitter -> this.client.listInstanceAgentCommands(request, new AsyncHandlerEmitter(emitter)));
    }
}

