/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.events;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.events.EventsAsyncClient;
import com.oracle.bmc.events.requests.ChangeRuleCompartmentRequest;
import com.oracle.bmc.events.requests.CreateRuleRequest;
import com.oracle.bmc.events.requests.DeleteRuleRequest;
import com.oracle.bmc.events.requests.GetRuleRequest;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.requests.UpdateRuleRequest;
import com.oracle.bmc.events.responses.ChangeRuleCompartmentResponse;
import com.oracle.bmc.events.responses.CreateRuleResponse;
import com.oracle.bmc.events.responses.DeleteRuleResponse;
import com.oracle.bmc.events.responses.GetRuleResponse;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.events.responses.UpdateRuleResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={EventsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EventsRxClient {
    EventsAsyncClient client;

    EventsRxClient(EventsAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeRuleCompartmentResponse> changeRuleCompartment(ChangeRuleCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeRuleCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateRuleResponse> createRule(CreateRuleRequest request) {
        return Single.create(emitter -> this.client.createRule(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteRuleResponse> deleteRule(DeleteRuleRequest request) {
        return Single.create(emitter -> this.client.deleteRule(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRuleResponse> getRule(GetRuleRequest request) {
        return Single.create(emitter -> this.client.getRule(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRulesResponse> listRules(ListRulesRequest request) {
        return Single.create(emitter -> this.client.listRules(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateRuleResponse> updateRule(UpdateRuleRequest request) {
        return Single.create(emitter -> this.client.updateRule(request, new AsyncHandlerEmitter(emitter)));
    }
}

