/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.marketplace;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.marketplace.AccountAsyncClient;
import com.oracle.bmc.marketplace.requests.GetLaunchEligibilityRequest;
import com.oracle.bmc.marketplace.requests.GetThirdPartyPaidListingEligibilityRequest;
import com.oracle.bmc.marketplace.responses.GetLaunchEligibilityResponse;
import com.oracle.bmc.marketplace.responses.GetThirdPartyPaidListingEligibilityResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AccountAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AccountRxClient {
    AccountAsyncClient client;

    AccountRxClient(AccountAsyncClient client) {
        this.client = client;
    }

    public Single<GetLaunchEligibilityResponse> getLaunchEligibility(GetLaunchEligibilityRequest request) {
        return Single.create(emitter -> this.client.getLaunchEligibility(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetThirdPartyPaidListingEligibilityResponse> getThirdPartyPaidListingEligibility(GetThirdPartyPaidListingEligibilityRequest request) {
        return Single.create(emitter -> this.client.getThirdPartyPaidListingEligibility(request, new AsyncHandlerEmitter(emitter)));
    }
}

