/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.monitoring;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.monitoring.MonitoringAsyncClient;
import com.oracle.bmc.monitoring.requests.ChangeAlarmCompartmentRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.requests.RemoveAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.SummarizeMetricsDataRequest;
import com.oracle.bmc.monitoring.requests.UpdateAlarmRequest;
import com.oracle.bmc.monitoring.responses.ChangeAlarmCompartmentResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.monitoring.responses.RemoveAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.SummarizeMetricsDataResponse;
import com.oracle.bmc.monitoring.responses.UpdateAlarmResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={MonitoringAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MonitoringRxClient {
    MonitoringAsyncClient client;

    MonitoringRxClient(MonitoringAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeAlarmCompartmentResponse> changeAlarmCompartment(ChangeAlarmCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeAlarmCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateAlarmResponse> createAlarm(CreateAlarmRequest request) {
        return Single.create(emitter -> this.client.createAlarm(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest request) {
        return Single.create(emitter -> this.client.deleteAlarm(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAlarmResponse> getAlarm(GetAlarmRequest request) {
        return Single.create(emitter -> this.client.getAlarm(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAlarmHistoryResponse> getAlarmHistory(GetAlarmHistoryRequest request) {
        return Single.create(emitter -> this.client.getAlarmHistory(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAlarmsResponse> listAlarms(ListAlarmsRequest request) {
        return Single.create(emitter -> this.client.listAlarms(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAlarmsStatusResponse> listAlarmsStatus(ListAlarmsStatusRequest request) {
        return Single.create(emitter -> this.client.listAlarmsStatus(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListMetricsResponse> listMetrics(ListMetricsRequest request) {
        return Single.create(emitter -> this.client.listMetrics(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<PostMetricDataResponse> postMetricData(PostMetricDataRequest request) {
        return Single.create(emitter -> this.client.postMetricData(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveAlarmSuppressionResponse> removeAlarmSuppression(RemoveAlarmSuppressionRequest request) {
        return Single.create(emitter -> this.client.removeAlarmSuppression(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeMetricsDataResponse> summarizeMetricsData(SummarizeMetricsDataRequest request) {
        return Single.create(emitter -> this.client.summarizeMetricsData(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAlarmResponse> updateAlarm(UpdateAlarmRequest request) {
        return Single.create(emitter -> this.client.updateAlarm(request, new AsyncHandlerEmitter(emitter)));
    }
}

