/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.oce;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.oce.OceInstanceAsyncClient;
import com.oracle.bmc.oce.requests.ChangeOceInstanceCompartmentRequest;
import com.oracle.bmc.oce.requests.CreateOceInstanceRequest;
import com.oracle.bmc.oce.requests.DeleteOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.requests.ListOceInstancesRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oce.requests.UpdateOceInstanceRequest;
import com.oracle.bmc.oce.responses.ChangeOceInstanceCompartmentResponse;
import com.oracle.bmc.oce.responses.CreateOceInstanceResponse;
import com.oracle.bmc.oce.responses.DeleteOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.oce.responses.ListOceInstancesResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oce.responses.UpdateOceInstanceResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OceInstanceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OceInstanceRxClient {
    OceInstanceAsyncClient client;

    OceInstanceRxClient(OceInstanceAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeOceInstanceCompartmentResponse> changeOceInstanceCompartment(ChangeOceInstanceCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeOceInstanceCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateOceInstanceResponse> createOceInstance(CreateOceInstanceRequest request) {
        return Single.create(emitter -> this.client.createOceInstance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteOceInstanceResponse> deleteOceInstance(DeleteOceInstanceRequest request) {
        return Single.create(emitter -> this.client.deleteOceInstance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOceInstanceResponse> getOceInstance(GetOceInstanceRequest request) {
        return Single.create(emitter -> this.client.getOceInstance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOceInstancesResponse> listOceInstances(ListOceInstancesRequest request) {
        return Single.create(emitter -> this.client.listOceInstances(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateOceInstanceResponse> updateOceInstance(UpdateOceInstanceRequest request) {
        return Single.create(emitter -> this.client.updateOceInstance(request, new AsyncHandlerEmitter(emitter)));
    }
}

