/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ocvp;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ocvp.EsxiHostAsyncClient;
import com.oracle.bmc.ocvp.requests.CreateEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.DeleteEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.GetEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.ListEsxiHostsRequest;
import com.oracle.bmc.ocvp.requests.UpdateEsxiHostRequest;
import com.oracle.bmc.ocvp.responses.CreateEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.DeleteEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.GetEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.ListEsxiHostsResponse;
import com.oracle.bmc.ocvp.responses.UpdateEsxiHostResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={EsxiHostAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EsxiHostRxClient {
    EsxiHostAsyncClient client;

    EsxiHostRxClient(EsxiHostAsyncClient client) {
        this.client = client;
    }

    public Single<CreateEsxiHostResponse> createEsxiHost(CreateEsxiHostRequest request) {
        return Single.create(emitter -> this.client.createEsxiHost(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteEsxiHostResponse> deleteEsxiHost(DeleteEsxiHostRequest request) {
        return Single.create(emitter -> this.client.deleteEsxiHost(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEsxiHostResponse> getEsxiHost(GetEsxiHostRequest request) {
        return Single.create(emitter -> this.client.getEsxiHost(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEsxiHostsResponse> listEsxiHosts(ListEsxiHostsRequest request) {
        return Single.create(emitter -> this.client.listEsxiHosts(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateEsxiHostResponse> updateEsxiHost(UpdateEsxiHostRequest request) {
        return Single.create(emitter -> this.client.updateEsxiHost(request, new AsyncHandlerEmitter(emitter)));
    }
}

