/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ocvp;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ocvp.SddcAsyncClient;
import com.oracle.bmc.ocvp.requests.CancelDowngradeHcxRequest;
import com.oracle.bmc.ocvp.requests.ChangeSddcCompartmentRequest;
import com.oracle.bmc.ocvp.requests.CreateSddcRequest;
import com.oracle.bmc.ocvp.requests.DeleteSddcRequest;
import com.oracle.bmc.ocvp.requests.DowngradeHcxRequest;
import com.oracle.bmc.ocvp.requests.GetSddcRequest;
import com.oracle.bmc.ocvp.requests.ListSddcsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedSkusRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedVmwareSoftwareVersionsRequest;
import com.oracle.bmc.ocvp.requests.RefreshHcxLicenseStatusRequest;
import com.oracle.bmc.ocvp.requests.UpdateSddcRequest;
import com.oracle.bmc.ocvp.requests.UpgradeHcxRequest;
import com.oracle.bmc.ocvp.responses.CancelDowngradeHcxResponse;
import com.oracle.bmc.ocvp.responses.ChangeSddcCompartmentResponse;
import com.oracle.bmc.ocvp.responses.CreateSddcResponse;
import com.oracle.bmc.ocvp.responses.DeleteSddcResponse;
import com.oracle.bmc.ocvp.responses.DowngradeHcxResponse;
import com.oracle.bmc.ocvp.responses.GetSddcResponse;
import com.oracle.bmc.ocvp.responses.ListSddcsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedSkusResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedVmwareSoftwareVersionsResponse;
import com.oracle.bmc.ocvp.responses.RefreshHcxLicenseStatusResponse;
import com.oracle.bmc.ocvp.responses.UpdateSddcResponse;
import com.oracle.bmc.ocvp.responses.UpgradeHcxResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={SddcAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SddcRxClient {
    SddcAsyncClient client;

    SddcRxClient(SddcAsyncClient client) {
        this.client = client;
    }

    public Single<CancelDowngradeHcxResponse> cancelDowngradeHcx(CancelDowngradeHcxRequest request) {
        return Single.create(emitter -> this.client.cancelDowngradeHcx(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeSddcCompartmentResponse> changeSddcCompartment(ChangeSddcCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeSddcCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSddcResponse> createSddc(CreateSddcRequest request) {
        return Single.create(emitter -> this.client.createSddc(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSddcResponse> deleteSddc(DeleteSddcRequest request) {
        return Single.create(emitter -> this.client.deleteSddc(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DowngradeHcxResponse> downgradeHcx(DowngradeHcxRequest request) {
        return Single.create(emitter -> this.client.downgradeHcx(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSddcResponse> getSddc(GetSddcRequest request) {
        return Single.create(emitter -> this.client.getSddc(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSddcsResponse> listSddcs(ListSddcsRequest request) {
        return Single.create(emitter -> this.client.listSddcs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSupportedSkusResponse> listSupportedSkus(ListSupportedSkusRequest request) {
        return Single.create(emitter -> this.client.listSupportedSkus(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSupportedVmwareSoftwareVersionsResponse> listSupportedVmwareSoftwareVersions(ListSupportedVmwareSoftwareVersionsRequest request) {
        return Single.create(emitter -> this.client.listSupportedVmwareSoftwareVersions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RefreshHcxLicenseStatusResponse> refreshHcxLicenseStatus(RefreshHcxLicenseStatusRequest request) {
        return Single.create(emitter -> this.client.refreshHcxLicenseStatus(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSddcResponse> updateSddc(UpdateSddcRequest request) {
        return Single.create(emitter -> this.client.updateSddc(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpgradeHcxResponse> upgradeHcx(UpgradeHcxRequest request) {
        return Single.create(emitter -> this.client.upgradeHcx(request, new AsyncHandlerEmitter(emitter)));
    }
}

