/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ons;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ons.NotificationControlPlaneAsyncClient;
import com.oracle.bmc.ons.requests.ChangeTopicCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateTopicRequest;
import com.oracle.bmc.ons.requests.DeleteTopicRequest;
import com.oracle.bmc.ons.requests.GetTopicRequest;
import com.oracle.bmc.ons.requests.ListTopicsRequest;
import com.oracle.bmc.ons.requests.UpdateTopicRequest;
import com.oracle.bmc.ons.responses.ChangeTopicCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateTopicResponse;
import com.oracle.bmc.ons.responses.DeleteTopicResponse;
import com.oracle.bmc.ons.responses.GetTopicResponse;
import com.oracle.bmc.ons.responses.ListTopicsResponse;
import com.oracle.bmc.ons.responses.UpdateTopicResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={NotificationControlPlaneAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class NotificationControlPlaneRxClient {
    NotificationControlPlaneAsyncClient client;

    NotificationControlPlaneRxClient(NotificationControlPlaneAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeTopicCompartmentResponse> changeTopicCompartment(ChangeTopicCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeTopicCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateTopicResponse> createTopic(CreateTopicRequest request) {
        return Single.create(emitter -> this.client.createTopic(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteTopicResponse> deleteTopic(DeleteTopicRequest request) {
        return Single.create(emitter -> this.client.deleteTopic(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTopicResponse> getTopic(GetTopicRequest request) {
        return Single.create(emitter -> this.client.getTopic(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListTopicsResponse> listTopics(ListTopicsRequest request) {
        return Single.create(emitter -> this.client.listTopics(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateTopicResponse> updateTopic(UpdateTopicRequest request) {
        return Single.create(emitter -> this.client.updateTopic(request, new AsyncHandlerEmitter(emitter)));
    }
}

