/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ons;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ons.NotificationDataPlaneAsyncClient;
import com.oracle.bmc.ons.requests.ChangeSubscriptionCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateSubscriptionRequest;
import com.oracle.bmc.ons.requests.DeleteSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetConfirmSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetUnsubscriptionRequest;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.requests.PublishMessageRequest;
import com.oracle.bmc.ons.requests.ResendSubscriptionConfirmationRequest;
import com.oracle.bmc.ons.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ons.responses.ChangeSubscriptionCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateSubscriptionResponse;
import com.oracle.bmc.ons.responses.DeleteSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetUnsubscriptionResponse;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ons.responses.PublishMessageResponse;
import com.oracle.bmc.ons.responses.ResendSubscriptionConfirmationResponse;
import com.oracle.bmc.ons.responses.UpdateSubscriptionResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={NotificationDataPlaneAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class NotificationDataPlaneRxClient {
    NotificationDataPlaneAsyncClient client;

    NotificationDataPlaneRxClient(NotificationDataPlaneAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeSubscriptionCompartmentResponse> changeSubscriptionCompartment(ChangeSubscriptionCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeSubscriptionCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest request) {
        return Single.create(emitter -> this.client.createSubscription(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSubscriptionResponse> deleteSubscription(DeleteSubscriptionRequest request) {
        return Single.create(emitter -> this.client.deleteSubscription(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetConfirmSubscriptionResponse> getConfirmSubscription(GetConfirmSubscriptionRequest request) {
        return Single.create(emitter -> this.client.getConfirmSubscription(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest request) {
        return Single.create(emitter -> this.client.getSubscription(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetUnsubscriptionResponse> getUnsubscription(GetUnsubscriptionRequest request) {
        return Single.create(emitter -> this.client.getUnsubscription(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request) {
        return Single.create(emitter -> this.client.listSubscriptions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<PublishMessageResponse> publishMessage(PublishMessageRequest request) {
        return Single.create(emitter -> this.client.publishMessage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ResendSubscriptionConfirmationResponse> resendSubscriptionConfirmation(ResendSubscriptionConfirmationRequest request) {
        return Single.create(emitter -> this.client.resendSubscriptionConfirmation(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest request) {
        return Single.create(emitter -> this.client.updateSubscription(request, new AsyncHandlerEmitter(emitter)));
    }
}

