/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.operatoraccesscontrol;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.operatoraccesscontrol.AccessRequestsAsyncClient;
import com.oracle.bmc.operatoraccesscontrol.requests.ApproveAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.GetAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestHistoriesRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.RejectAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.RevokeAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ApproveAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.GetAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestHistoriesResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.RejectAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.RevokeAccessRequestResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AccessRequestsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AccessRequestsRxClient {
    AccessRequestsAsyncClient client;

    AccessRequestsRxClient(AccessRequestsAsyncClient client) {
        this.client = client;
    }

    public Single<ApproveAccessRequestResponse> approveAccessRequest(ApproveAccessRequestRequest request) {
        return Single.create(emitter -> this.client.approveAccessRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAccessRequestResponse> getAccessRequest(GetAccessRequestRequest request) {
        return Single.create(emitter -> this.client.getAccessRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAccessRequestHistoriesResponse> listAccessRequestHistories(ListAccessRequestHistoriesRequest request) {
        return Single.create(emitter -> this.client.listAccessRequestHistories(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAccessRequestsResponse> listAccessRequests(ListAccessRequestsRequest request) {
        return Single.create(emitter -> this.client.listAccessRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RejectAccessRequestResponse> rejectAccessRequest(RejectAccessRequestRequest request) {
        return Single.create(emitter -> this.client.rejectAccessRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RevokeAccessRequestResponse> revokeAccessRequest(RevokeAccessRequestRequest request) {
        return Single.create(emitter -> this.client.revokeAccessRequest(request, new AsyncHandlerEmitter(emitter)));
    }
}

