/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.sch;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.sch.ServiceConnectorAsyncClient;
import com.oracle.bmc.sch.requests.ActivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.ChangeServiceConnectorCompartmentRequest;
import com.oracle.bmc.sch.requests.CreateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeactivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeleteServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetWorkRequestRequest;
import com.oracle.bmc.sch.requests.ListServiceConnectorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.sch.requests.UpdateServiceConnectorRequest;
import com.oracle.bmc.sch.responses.ActivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.ChangeServiceConnectorCompartmentResponse;
import com.oracle.bmc.sch.responses.CreateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeactivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeleteServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetWorkRequestResponse;
import com.oracle.bmc.sch.responses.ListServiceConnectorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.sch.responses.UpdateServiceConnectorResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ServiceConnectorAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ServiceConnectorRxClient {
    ServiceConnectorAsyncClient client;

    ServiceConnectorRxClient(ServiceConnectorAsyncClient client) {
        this.client = client;
    }

    public Single<ActivateServiceConnectorResponse> activateServiceConnector(ActivateServiceConnectorRequest request) {
        return Single.create(emitter -> this.client.activateServiceConnector(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeServiceConnectorCompartmentResponse> changeServiceConnectorCompartment(ChangeServiceConnectorCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeServiceConnectorCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateServiceConnectorResponse> createServiceConnector(CreateServiceConnectorRequest request) {
        return Single.create(emitter -> this.client.createServiceConnector(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeactivateServiceConnectorResponse> deactivateServiceConnector(DeactivateServiceConnectorRequest request) {
        return Single.create(emitter -> this.client.deactivateServiceConnector(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteServiceConnectorResponse> deleteServiceConnector(DeleteServiceConnectorRequest request) {
        return Single.create(emitter -> this.client.deleteServiceConnector(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetServiceConnectorResponse> getServiceConnector(GetServiceConnectorRequest request) {
        return Single.create(emitter -> this.client.getServiceConnector(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListServiceConnectorsResponse> listServiceConnectors(ListServiceConnectorsRequest request) {
        return Single.create(emitter -> this.client.listServiceConnectors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateServiceConnectorResponse> updateServiceConnector(UpdateServiceConnectorRequest request) {
        return Single.create(emitter -> this.client.updateServiceConnector(request, new AsyncHandlerEmitter(emitter)));
    }
}

