/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitationAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.AcceptRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.IgnoreRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListRecipientInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.AcceptRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.IgnoreRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListRecipientInvitationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateRecipientInvitationResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={RecipientInvitationAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class RecipientInvitationRxClient {
    RecipientInvitationAsyncClient client;

    RecipientInvitationRxClient(RecipientInvitationAsyncClient client) {
        this.client = client;
    }

    public Single<AcceptRecipientInvitationResponse> acceptRecipientInvitation(AcceptRecipientInvitationRequest request) {
        return Single.create(emitter -> this.client.acceptRecipientInvitation(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRecipientInvitationResponse> getRecipientInvitation(GetRecipientInvitationRequest request) {
        return Single.create(emitter -> this.client.getRecipientInvitation(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<IgnoreRecipientInvitationResponse> ignoreRecipientInvitation(IgnoreRecipientInvitationRequest request) {
        return Single.create(emitter -> this.client.ignoreRecipientInvitation(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRecipientInvitationsResponse> listRecipientInvitations(ListRecipientInvitationsRequest request) {
        return Single.create(emitter -> this.client.listRecipientInvitations(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateRecipientInvitationResponse> updateRecipientInvitation(UpdateRecipientInvitationRequest request) {
        return Single.create(emitter -> this.client.updateRecipientInvitation(request, new AsyncHandlerEmitter(emitter)));
    }
}

