/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.tenantmanagercontrolplane.WorkRequestAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetWorkRequestRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListWorkRequestsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetWorkRequestResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListWorkRequestsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={WorkRequestAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WorkRequestRxClient {
    WorkRequestAsyncClient client;

    WorkRequestRxClient(WorkRequestAsyncClient client) {
        this.client = client;
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }
}

