/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.usageapi;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.usageapi.UsageapiAsyncClient;
import com.oracle.bmc.usageapi.requests.CreateQueryRequest;
import com.oracle.bmc.usageapi.requests.DeleteQueryRequest;
import com.oracle.bmc.usageapi.requests.GetQueryRequest;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedConfigurationsRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedUsagesRequest;
import com.oracle.bmc.usageapi.requests.UpdateQueryRequest;
import com.oracle.bmc.usageapi.responses.CreateQueryResponse;
import com.oracle.bmc.usageapi.responses.DeleteQueryResponse;
import com.oracle.bmc.usageapi.responses.GetQueryResponse;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedUsagesResponse;
import com.oracle.bmc.usageapi.responses.UpdateQueryResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={UsageapiAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class UsageapiRxClient {
    UsageapiAsyncClient client;

    UsageapiRxClient(UsageapiAsyncClient client) {
        this.client = client;
    }

    public Single<CreateQueryResponse> createQuery(CreateQueryRequest request) {
        return Single.create(emitter -> this.client.createQuery(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteQueryResponse> deleteQuery(DeleteQueryRequest request) {
        return Single.create(emitter -> this.client.deleteQuery(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetQueryResponse> getQuery(GetQueryRequest request) {
        return Single.create(emitter -> this.client.getQuery(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListQueriesResponse> listQueries(ListQueriesRequest request) {
        return Single.create(emitter -> this.client.listQueries(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RequestSummarizedConfigurationsResponse> requestSummarizedConfigurations(RequestSummarizedConfigurationsRequest request) {
        return Single.create(emitter -> this.client.requestSummarizedConfigurations(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RequestSummarizedUsagesResponse> requestSummarizedUsages(RequestSummarizedUsagesRequest request) {
        return Single.create(emitter -> this.client.requestSummarizedUsages(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateQueryResponse> updateQuery(UpdateQueryRequest request) {
        return Single.create(emitter -> this.client.updateQuery(request, new AsyncHandlerEmitter(emitter)));
    }
}

