/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.aivision;

import com.oracle.bmc.aivision.AIServiceVisionAsyncClient;
import com.oracle.bmc.aivision.requests.AnalyzeDocumentRequest;
import com.oracle.bmc.aivision.requests.AnalyzeImageRequest;
import com.oracle.bmc.aivision.requests.CancelDocumentJobRequest;
import com.oracle.bmc.aivision.requests.CancelImageJobRequest;
import com.oracle.bmc.aivision.requests.CancelWorkRequestRequest;
import com.oracle.bmc.aivision.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.aivision.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.aivision.requests.CreateDocumentJobRequest;
import com.oracle.bmc.aivision.requests.CreateImageJobRequest;
import com.oracle.bmc.aivision.requests.CreateModelRequest;
import com.oracle.bmc.aivision.requests.CreateProjectRequest;
import com.oracle.bmc.aivision.requests.DeleteModelRequest;
import com.oracle.bmc.aivision.requests.DeleteProjectRequest;
import com.oracle.bmc.aivision.requests.GetDocumentJobRequest;
import com.oracle.bmc.aivision.requests.GetImageJobRequest;
import com.oracle.bmc.aivision.requests.GetModelRequest;
import com.oracle.bmc.aivision.requests.GetProjectRequest;
import com.oracle.bmc.aivision.requests.GetWorkRequestRequest;
import com.oracle.bmc.aivision.requests.ListModelsRequest;
import com.oracle.bmc.aivision.requests.ListProjectsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aivision.requests.UpdateModelRequest;
import com.oracle.bmc.aivision.requests.UpdateProjectRequest;
import com.oracle.bmc.aivision.responses.AnalyzeDocumentResponse;
import com.oracle.bmc.aivision.responses.AnalyzeImageResponse;
import com.oracle.bmc.aivision.responses.CancelDocumentJobResponse;
import com.oracle.bmc.aivision.responses.CancelImageJobResponse;
import com.oracle.bmc.aivision.responses.CancelWorkRequestResponse;
import com.oracle.bmc.aivision.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.aivision.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.aivision.responses.CreateDocumentJobResponse;
import com.oracle.bmc.aivision.responses.CreateImageJobResponse;
import com.oracle.bmc.aivision.responses.CreateModelResponse;
import com.oracle.bmc.aivision.responses.CreateProjectResponse;
import com.oracle.bmc.aivision.responses.DeleteModelResponse;
import com.oracle.bmc.aivision.responses.DeleteProjectResponse;
import com.oracle.bmc.aivision.responses.GetDocumentJobResponse;
import com.oracle.bmc.aivision.responses.GetImageJobResponse;
import com.oracle.bmc.aivision.responses.GetModelResponse;
import com.oracle.bmc.aivision.responses.GetProjectResponse;
import com.oracle.bmc.aivision.responses.GetWorkRequestResponse;
import com.oracle.bmc.aivision.responses.ListModelsResponse;
import com.oracle.bmc.aivision.responses.ListProjectsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestsResponse;
import com.oracle.bmc.aivision.responses.UpdateModelResponse;
import com.oracle.bmc.aivision.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AIServiceVisionAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AIServiceVisionRxClient {
    AIServiceVisionAsyncClient client;

    AIServiceVisionRxClient(AIServiceVisionAsyncClient client) {
        this.client = client;
    }

    public Single<AnalyzeDocumentResponse> analyzeDocument(AnalyzeDocumentRequest request) {
        return Single.create(emitter -> this.client.analyzeDocument(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<AnalyzeImageResponse> analyzeImage(AnalyzeImageRequest request) {
        return Single.create(emitter -> this.client.analyzeImage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelDocumentJobResponse> cancelDocumentJob(CancelDocumentJobRequest request) {
        return Single.create(emitter -> this.client.cancelDocumentJob(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelImageJobResponse> cancelImageJob(CancelImageJobRequest request) {
        return Single.create(emitter -> this.client.cancelImageJob(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeModelCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeProjectCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateDocumentJobResponse> createDocumentJob(CreateDocumentJobRequest request) {
        return Single.create(emitter -> this.client.createDocumentJob(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateImageJobResponse> createImageJob(CreateImageJobRequest request) {
        return Single.create(emitter -> this.client.createImageJob(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateModelResponse> createModel(CreateModelRequest request) {
        return Single.create(emitter -> this.client.createModel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateProjectResponse> createProject(CreateProjectRequest request) {
        return Single.create(emitter -> this.client.createProject(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteModelResponse> deleteModel(DeleteModelRequest request) {
        return Single.create(emitter -> this.client.deleteModel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteProjectResponse> deleteProject(DeleteProjectRequest request) {
        return Single.create(emitter -> this.client.deleteProject(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetDocumentJobResponse> getDocumentJob(GetDocumentJobRequest request) {
        return Single.create(emitter -> this.client.getDocumentJob(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetImageJobResponse> getImageJob(GetImageJobRequest request) {
        return Single.create(emitter -> this.client.getImageJob(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetModelResponse> getModel(GetModelRequest request) {
        return Single.create(emitter -> this.client.getModel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetProjectResponse> getProject(GetProjectRequest request) {
        return Single.create(emitter -> this.client.getProject(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListModelsResponse> listModels(ListModelsRequest request) {
        return Single.create(emitter -> this.client.listModels(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListProjectsResponse> listProjects(ListProjectsRequest request) {
        return Single.create(emitter -> this.client.listProjects(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateModelResponse> updateModel(UpdateModelRequest request) {
        return Single.create(emitter -> this.client.updateModel(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateProjectResponse> updateProject(UpdateProjectRequest request) {
        return Single.create(emitter -> this.client.updateProject(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

