/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.announcementsservice;

import com.oracle.bmc.announcementsservice.AnnouncementAsyncClient;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementRequest;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementsRequest;
import com.oracle.bmc.announcementsservice.requests.UpdateAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementResponse;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementUserStatusResponse;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementsResponse;
import com.oracle.bmc.announcementsservice.responses.UpdateAnnouncementUserStatusResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AnnouncementAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AnnouncementRxClient {
    AnnouncementAsyncClient client;

    AnnouncementRxClient(AnnouncementAsyncClient client) {
        this.client = client;
    }

    public Single<GetAnnouncementResponse> getAnnouncement(GetAnnouncementRequest request) {
        return Single.create(emitter -> this.client.getAnnouncement(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAnnouncementUserStatusResponse> getAnnouncementUserStatus(GetAnnouncementUserStatusRequest request) {
        return Single.create(emitter -> this.client.getAnnouncementUserStatus(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAnnouncementsResponse> listAnnouncements(ListAnnouncementsRequest request) {
        return Single.create(emitter -> this.client.listAnnouncements(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAnnouncementUserStatusResponse> updateAnnouncementUserStatus(UpdateAnnouncementUserStatusRequest request) {
        return Single.create(emitter -> this.client.updateAnnouncementUserStatus(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

