/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apigateway;

import com.oracle.bmc.apigateway.GatewayAsyncClient;
import com.oracle.bmc.apigateway.requests.ChangeGatewayCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateGatewayRequest;
import com.oracle.bmc.apigateway.requests.DeleteGatewayRequest;
import com.oracle.bmc.apigateway.requests.GetGatewayRequest;
import com.oracle.bmc.apigateway.requests.ListGatewaysRequest;
import com.oracle.bmc.apigateway.requests.UpdateGatewayRequest;
import com.oracle.bmc.apigateway.responses.ChangeGatewayCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateGatewayResponse;
import com.oracle.bmc.apigateway.responses.DeleteGatewayResponse;
import com.oracle.bmc.apigateway.responses.GetGatewayResponse;
import com.oracle.bmc.apigateway.responses.ListGatewaysResponse;
import com.oracle.bmc.apigateway.responses.UpdateGatewayResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={GatewayAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GatewayRxClient {
    GatewayAsyncClient client;

    GatewayRxClient(GatewayAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeGatewayCompartmentResponse> changeGatewayCompartment(ChangeGatewayCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeGatewayCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateGatewayResponse> createGateway(CreateGatewayRequest request) {
        return Single.create(emitter -> this.client.createGateway(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest request) {
        return Single.create(emitter -> this.client.deleteGateway(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetGatewayResponse> getGateway(GetGatewayRequest request) {
        return Single.create(emitter -> this.client.getGateway(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListGatewaysResponse> listGateways(ListGatewaysRequest request) {
        return Single.create(emitter -> this.client.listGateways(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest request) {
        return Single.create(emitter -> this.client.updateGateway(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

