/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.budget;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.budget.BudgetAsyncClient;
import com.oracle.bmc.budget.requests.CreateAlertRuleRequest;
import com.oracle.bmc.budget.requests.CreateBudgetRequest;
import com.oracle.bmc.budget.requests.DeleteAlertRuleRequest;
import com.oracle.bmc.budget.requests.DeleteBudgetRequest;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.requests.UpdateAlertRuleRequest;
import com.oracle.bmc.budget.requests.UpdateBudgetRequest;
import com.oracle.bmc.budget.responses.CreateAlertRuleResponse;
import com.oracle.bmc.budget.responses.CreateBudgetResponse;
import com.oracle.bmc.budget.responses.DeleteAlertRuleResponse;
import com.oracle.bmc.budget.responses.DeleteBudgetResponse;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.budget.responses.UpdateAlertRuleResponse;
import com.oracle.bmc.budget.responses.UpdateBudgetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={BudgetAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class BudgetRxClient {
    BudgetAsyncClient client;

    BudgetRxClient(BudgetAsyncClient client) {
        this.client = client;
    }

    public Single<CreateAlertRuleResponse> createAlertRule(CreateAlertRuleRequest request) {
        return Single.create(emitter -> this.client.createAlertRule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateBudgetResponse> createBudget(CreateBudgetRequest request) {
        return Single.create(emitter -> this.client.createBudget(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAlertRuleResponse> deleteAlertRule(DeleteAlertRuleRequest request) {
        return Single.create(emitter -> this.client.deleteAlertRule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest request) {
        return Single.create(emitter -> this.client.deleteBudget(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAlertRuleResponse> getAlertRule(GetAlertRuleRequest request) {
        return Single.create(emitter -> this.client.getAlertRule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetBudgetResponse> getBudget(GetBudgetRequest request) {
        return Single.create(emitter -> this.client.getBudget(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAlertRulesResponse> listAlertRules(ListAlertRulesRequest request) {
        return Single.create(emitter -> this.client.listAlertRules(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListBudgetsResponse> listBudgets(ListBudgetsRequest request) {
        return Single.create(emitter -> this.client.listBudgets(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAlertRuleResponse> updateAlertRule(UpdateAlertRuleRequest request) {
        return Single.create(emitter -> this.client.updateAlertRule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest request) {
        return Single.create(emitter -> this.client.updateBudget(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

