/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.cloudbridge;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.InventoryAsyncClient;
import com.oracle.bmc.cloudbridge.requests.AnalyzeAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetTagsRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.CreateInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetRequest;
import com.oracle.bmc.cloudbridge.requests.GetInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ImportInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ListHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.ListInventoriesRequest;
import com.oracle.bmc.cloudbridge.requests.SubmitHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateInventoryRequest;
import com.oracle.bmc.cloudbridge.responses.AnalyzeAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetTagsResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.CreateInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetResponse;
import com.oracle.bmc.cloudbridge.responses.GetInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ImportInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ListHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.ListInventoriesResponse;
import com.oracle.bmc.cloudbridge.responses.SubmitHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateInventoryResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={InventoryAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class InventoryRxClient {
    InventoryAsyncClient client;

    InventoryRxClient(InventoryAsyncClient client) {
        this.client = client;
    }

    public Single<AnalyzeAssetsResponse> analyzeAssets(AnalyzeAssetsRequest request) {
        return Single.create(emitter -> this.client.analyzeAssets(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeAssetCompartmentResponse> changeAssetCompartment(ChangeAssetCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeAssetCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeAssetTagsResponse> changeAssetTags(ChangeAssetTagsRequest request) {
        return Single.create(emitter -> this.client.changeAssetTags(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateAssetResponse> createAsset(CreateAssetRequest request) {
        return Single.create(emitter -> this.client.createAsset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateInventoryResponse> createInventory(CreateInventoryRequest request) {
        return Single.create(emitter -> this.client.createInventory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAssetResponse> deleteAsset(DeleteAssetRequest request) {
        return Single.create(emitter -> this.client.deleteAsset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteInventoryResponse> deleteInventory(DeleteInventoryRequest request) {
        return Single.create(emitter -> this.client.deleteInventory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAssetResponse> getAsset(GetAssetRequest request) {
        return Single.create(emitter -> this.client.getAsset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetInventoryResponse> getInventory(GetInventoryRequest request) {
        return Single.create(emitter -> this.client.getInventory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ImportInventoryResponse> importInventory(ImportInventoryRequest request) {
        return Single.create(emitter -> this.client.importInventory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAssetsResponse> listAssets(ListAssetsRequest request) {
        return Single.create(emitter -> this.client.listAssets(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListHistoricalMetricsResponse> listHistoricalMetrics(ListHistoricalMetricsRequest request) {
        return Single.create(emitter -> this.client.listHistoricalMetrics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListInventoriesResponse> listInventories(ListInventoriesRequest request) {
        return Single.create(emitter -> this.client.listInventories(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SubmitHistoricalMetricsResponse> submitHistoricalMetrics(SubmitHistoricalMetricsRequest request) {
        return Single.create(emitter -> this.client.submitHistoricalMetrics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAssetResponse> updateAsset(UpdateAssetRequest request) {
        return Single.create(emitter -> this.client.updateAsset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateInventoryResponse> updateInventory(UpdateInventoryRequest request) {
        return Single.create(emitter -> this.client.updateInventory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

