/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.databasemanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.databasemanagement.SqlTuningAsyncClient;
import com.oracle.bmc.databasemanagement.requests.CloneSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.CreateSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlsInSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.FetchSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.GetExecutionPlanStatsComparisionRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlExecutionPlanRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlTuningAdvisorTaskSummaryReportRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTaskFindingsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTaskRecommendationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTasksRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningSetsRequest;
import com.oracle.bmc.databasemanagement.requests.LoadSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.SaveSqlTuningSetAsRequest;
import com.oracle.bmc.databasemanagement.requests.StartSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.ValidateBasicFilterRequest;
import com.oracle.bmc.databasemanagement.responses.CloneSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.CreateSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlsInSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.FetchSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.GetExecutionPlanStatsComparisionResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlExecutionPlanResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlTuningAdvisorTaskSummaryReportResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTaskFindingsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTaskRecommendationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTasksResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningSetsResponse;
import com.oracle.bmc.databasemanagement.responses.LoadSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.SaveSqlTuningSetAsResponse;
import com.oracle.bmc.databasemanagement.responses.StartSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.ValidateBasicFilterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={SqlTuningAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SqlTuningRxClient {
    SqlTuningAsyncClient client;

    SqlTuningRxClient(SqlTuningAsyncClient client) {
        this.client = client;
    }

    public Single<CloneSqlTuningTaskResponse> cloneSqlTuningTask(CloneSqlTuningTaskRequest request) {
        return Single.create(emitter -> this.client.cloneSqlTuningTask(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSqlTuningSetResponse> createSqlTuningSet(CreateSqlTuningSetRequest request) {
        return Single.create(emitter -> this.client.createSqlTuningSet(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DropSqlTuningSetResponse> dropSqlTuningSet(DropSqlTuningSetRequest request) {
        return Single.create(emitter -> this.client.dropSqlTuningSet(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DropSqlTuningTaskResponse> dropSqlTuningTask(DropSqlTuningTaskRequest request) {
        return Single.create(emitter -> this.client.dropSqlTuningTask(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DropSqlsInSqlTuningSetResponse> dropSqlsInSqlTuningSet(DropSqlsInSqlTuningSetRequest request) {
        return Single.create(emitter -> this.client.dropSqlsInSqlTuningSet(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<FetchSqlTuningSetResponse> fetchSqlTuningSet(FetchSqlTuningSetRequest request) {
        return Single.create(emitter -> this.client.fetchSqlTuningSet(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetExecutionPlanStatsComparisionResponse> getExecutionPlanStatsComparision(GetExecutionPlanStatsComparisionRequest request) {
        return Single.create(emitter -> this.client.getExecutionPlanStatsComparision(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSqlExecutionPlanResponse> getSqlExecutionPlan(GetSqlExecutionPlanRequest request) {
        return Single.create(emitter -> this.client.getSqlExecutionPlan(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSqlTuningAdvisorTaskSummaryReportResponse> getSqlTuningAdvisorTaskSummaryReport(GetSqlTuningAdvisorTaskSummaryReportRequest request) {
        return Single.create(emitter -> this.client.getSqlTuningAdvisorTaskSummaryReport(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSqlTuningAdvisorTaskFindingsResponse> listSqlTuningAdvisorTaskFindings(ListSqlTuningAdvisorTaskFindingsRequest request) {
        return Single.create(emitter -> this.client.listSqlTuningAdvisorTaskFindings(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSqlTuningAdvisorTaskRecommendationsResponse> listSqlTuningAdvisorTaskRecommendations(ListSqlTuningAdvisorTaskRecommendationsRequest request) {
        return Single.create(emitter -> this.client.listSqlTuningAdvisorTaskRecommendations(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSqlTuningAdvisorTasksResponse> listSqlTuningAdvisorTasks(ListSqlTuningAdvisorTasksRequest request) {
        return Single.create(emitter -> this.client.listSqlTuningAdvisorTasks(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSqlTuningSetsResponse> listSqlTuningSets(ListSqlTuningSetsRequest request) {
        return Single.create(emitter -> this.client.listSqlTuningSets(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<LoadSqlTuningSetResponse> loadSqlTuningSet(LoadSqlTuningSetRequest request) {
        return Single.create(emitter -> this.client.loadSqlTuningSet(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SaveSqlTuningSetAsResponse> saveSqlTuningSetAs(SaveSqlTuningSetAsRequest request) {
        return Single.create(emitter -> this.client.saveSqlTuningSetAs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<StartSqlTuningTaskResponse> startSqlTuningTask(StartSqlTuningTaskRequest request) {
        return Single.create(emitter -> this.client.startSqlTuningTask(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ValidateBasicFilterResponse> validateBasicFilter(ValidateBasicFilterRequest request) {
        return Single.create(emitter -> this.client.validateBasicFilter(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

