/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsVaultAsyncClient;
import com.oracle.bmc.keymanagement.requests.BackupVaultRequest;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.DeleteVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultUsageRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultReplicasRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.BackupVaultResponse;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.DeleteVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultUsageResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultReplicasResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={KmsVaultAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsVaultRxClient {
    KmsVaultAsyncClient client;

    KmsVaultRxClient(KmsVaultAsyncClient client) {
        this.client = client;
    }

    public Single<BackupVaultResponse> backupVault(BackupVaultRequest request) {
        return Single.create(emitter -> this.client.backupVault(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelVaultDeletionResponse> cancelVaultDeletion(CancelVaultDeletionRequest request) {
        return Single.create(emitter -> this.client.cancelVaultDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeVaultCompartmentResponse> changeVaultCompartment(ChangeVaultCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeVaultCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateVaultResponse> createVault(CreateVaultRequest request) {
        return Single.create(emitter -> this.client.createVault(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateVaultReplicaResponse> createVaultReplica(CreateVaultReplicaRequest request) {
        return Single.create(emitter -> this.client.createVaultReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteVaultReplicaResponse> deleteVaultReplica(DeleteVaultReplicaRequest request) {
        return Single.create(emitter -> this.client.deleteVaultReplica(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetVaultResponse> getVault(GetVaultRequest request) {
        return Single.create(emitter -> this.client.getVault(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetVaultUsageResponse> getVaultUsage(GetVaultUsageRequest request) {
        return Single.create(emitter -> this.client.getVaultUsage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListVaultReplicasResponse> listVaultReplicas(ListVaultReplicasRequest request) {
        return Single.create(emitter -> this.client.listVaultReplicas(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListVaultsResponse> listVaults(ListVaultsRequest request) {
        return Single.create(emitter -> this.client.listVaults(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestoreVaultFromFileResponse> restoreVaultFromFile(RestoreVaultFromFileRequest request) {
        return Single.create(emitter -> this.client.restoreVaultFromFile(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestoreVaultFromObjectStoreResponse> restoreVaultFromObjectStore(RestoreVaultFromObjectStoreRequest request) {
        return Single.create(emitter -> this.client.restoreVaultFromObjectStore(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScheduleVaultDeletionResponse> scheduleVaultDeletion(ScheduleVaultDeletionRequest request) {
        return Single.create(emitter -> this.client.scheduleVaultDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateVaultResponse> updateVault(UpdateVaultRequest request) {
        return Single.create(emitter -> this.client.updateVault(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

