/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.lockbox;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.lockbox.LockboxAsyncClient;
import com.oracle.bmc.lockbox.requests.CancelWorkRequestRequest;
import com.oracle.bmc.lockbox.requests.ChangeApprovalTemplateCompartmentRequest;
import com.oracle.bmc.lockbox.requests.ChangeLockboxCompartmentRequest;
import com.oracle.bmc.lockbox.requests.CreateAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.CreateApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.CreateLockboxRequest;
import com.oracle.bmc.lockbox.requests.DeleteApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.DeleteLockboxRequest;
import com.oracle.bmc.lockbox.requests.ExportAccessRequestsRequest;
import com.oracle.bmc.lockbox.requests.GetAccessMaterialsRequest;
import com.oracle.bmc.lockbox.requests.GetAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.GetApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.GetLockboxRequest;
import com.oracle.bmc.lockbox.requests.GetWorkRequestRequest;
import com.oracle.bmc.lockbox.requests.HandleAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.ListAccessRequestsRequest;
import com.oracle.bmc.lockbox.requests.ListApprovalTemplatesRequest;
import com.oracle.bmc.lockbox.requests.ListLockboxesRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestsRequest;
import com.oracle.bmc.lockbox.requests.UpdateApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.UpdateLockboxRequest;
import com.oracle.bmc.lockbox.responses.CancelWorkRequestResponse;
import com.oracle.bmc.lockbox.responses.ChangeApprovalTemplateCompartmentResponse;
import com.oracle.bmc.lockbox.responses.ChangeLockboxCompartmentResponse;
import com.oracle.bmc.lockbox.responses.CreateAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.CreateApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.CreateLockboxResponse;
import com.oracle.bmc.lockbox.responses.DeleteApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.DeleteLockboxResponse;
import com.oracle.bmc.lockbox.responses.ExportAccessRequestsResponse;
import com.oracle.bmc.lockbox.responses.GetAccessMaterialsResponse;
import com.oracle.bmc.lockbox.responses.GetAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.GetApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.GetLockboxResponse;
import com.oracle.bmc.lockbox.responses.GetWorkRequestResponse;
import com.oracle.bmc.lockbox.responses.HandleAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.ListAccessRequestsResponse;
import com.oracle.bmc.lockbox.responses.ListApprovalTemplatesResponse;
import com.oracle.bmc.lockbox.responses.ListLockboxesResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestsResponse;
import com.oracle.bmc.lockbox.responses.UpdateApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.UpdateLockboxResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={LockboxAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class LockboxRxClient {
    LockboxAsyncClient client;

    LockboxRxClient(LockboxAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeApprovalTemplateCompartmentResponse> changeApprovalTemplateCompartment(ChangeApprovalTemplateCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeApprovalTemplateCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeLockboxCompartmentResponse> changeLockboxCompartment(ChangeLockboxCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeLockboxCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateAccessRequestResponse> createAccessRequest(CreateAccessRequestRequest request) {
        return Single.create(emitter -> this.client.createAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateApprovalTemplateResponse> createApprovalTemplate(CreateApprovalTemplateRequest request) {
        return Single.create(emitter -> this.client.createApprovalTemplate(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateLockboxResponse> createLockbox(CreateLockboxRequest request) {
        return Single.create(emitter -> this.client.createLockbox(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteApprovalTemplateResponse> deleteApprovalTemplate(DeleteApprovalTemplateRequest request) {
        return Single.create(emitter -> this.client.deleteApprovalTemplate(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteLockboxResponse> deleteLockbox(DeleteLockboxRequest request) {
        return Single.create(emitter -> this.client.deleteLockbox(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ExportAccessRequestsResponse> exportAccessRequests(ExportAccessRequestsRequest request) {
        return Single.create(emitter -> this.client.exportAccessRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAccessMaterialsResponse> getAccessMaterials(GetAccessMaterialsRequest request) {
        return Single.create(emitter -> this.client.getAccessMaterials(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAccessRequestResponse> getAccessRequest(GetAccessRequestRequest request) {
        return Single.create(emitter -> this.client.getAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApprovalTemplateResponse> getApprovalTemplate(GetApprovalTemplateRequest request) {
        return Single.create(emitter -> this.client.getApprovalTemplate(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetLockboxResponse> getLockbox(GetLockboxRequest request) {
        return Single.create(emitter -> this.client.getLockbox(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<HandleAccessRequestResponse> handleAccessRequest(HandleAccessRequestRequest request) {
        return Single.create(emitter -> this.client.handleAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAccessRequestsResponse> listAccessRequests(ListAccessRequestsRequest request) {
        return Single.create(emitter -> this.client.listAccessRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListApprovalTemplatesResponse> listApprovalTemplates(ListApprovalTemplatesRequest request) {
        return Single.create(emitter -> this.client.listApprovalTemplates(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLockboxesResponse> listLockboxes(ListLockboxesRequest request) {
        return Single.create(emitter -> this.client.listLockboxes(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateApprovalTemplateResponse> updateApprovalTemplate(UpdateApprovalTemplateRequest request) {
        return Single.create(emitter -> this.client.updateApprovalTemplate(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateLockboxResponse> updateLockbox(UpdateLockboxRequest request) {
        return Single.create(emitter -> this.client.updateLockbox(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

