/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mediaservices;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mediaservices.MediaStreamAsyncClient;
import com.oracle.bmc.mediaservices.requests.GeneratePlaylistRequest;
import com.oracle.bmc.mediaservices.requests.GenerateSessionTokenRequest;
import com.oracle.bmc.mediaservices.responses.GeneratePlaylistResponse;
import com.oracle.bmc.mediaservices.responses.GenerateSessionTokenResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={MediaStreamAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MediaStreamRxClient {
    MediaStreamAsyncClient client;

    MediaStreamRxClient(MediaStreamAsyncClient client) {
        this.client = client;
    }

    public Single<GeneratePlaylistResponse> generatePlaylist(GeneratePlaylistRequest request) {
        return Single.create(emitter -> this.client.generatePlaylist(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GenerateSessionTokenResponse> generateSessionToken(GenerateSessionTokenRequest request) {
        return Single.create(emitter -> this.client.generateSessionToken(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

