/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.DbBackupsAsyncClient;
import com.oracle.bmc.mysql.requests.ChangeBackupCompartmentRequest;
import com.oracle.bmc.mysql.requests.CreateBackupRequest;
import com.oracle.bmc.mysql.requests.DeleteBackupRequest;
import com.oracle.bmc.mysql.requests.GetBackupRequest;
import com.oracle.bmc.mysql.requests.ListBackupsRequest;
import com.oracle.bmc.mysql.requests.UpdateBackupRequest;
import com.oracle.bmc.mysql.responses.ChangeBackupCompartmentResponse;
import com.oracle.bmc.mysql.responses.CreateBackupResponse;
import com.oracle.bmc.mysql.responses.DeleteBackupResponse;
import com.oracle.bmc.mysql.responses.GetBackupResponse;
import com.oracle.bmc.mysql.responses.ListBackupsResponse;
import com.oracle.bmc.mysql.responses.UpdateBackupResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DbBackupsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DbBackupsRxClient {
    DbBackupsAsyncClient client;

    DbBackupsRxClient(DbBackupsAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeBackupCompartmentResponse> changeBackupCompartment(ChangeBackupCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeBackupCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateBackupResponse> createBackup(CreateBackupRequest request) {
        return Single.create(emitter -> this.client.createBackup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteBackupResponse> deleteBackup(DeleteBackupRequest request) {
        return Single.create(emitter -> this.client.deleteBackup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetBackupResponse> getBackup(GetBackupRequest request) {
        return Single.create(emitter -> this.client.getBackup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListBackupsResponse> listBackups(ListBackupsRequest request) {
        return Single.create(emitter -> this.client.listBackups(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateBackupResponse> updateBackup(UpdateBackupRequest request) {
        return Single.create(emitter -> this.client.updateBackup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

