/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ocicontrolcenter;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ocicontrolcenter.OccMetricsAsyncClient;
import com.oracle.bmc.ocicontrolcenter.requests.ListMetricPropertiesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.ListNamespacesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.RequestSummarizedMetricDataRequest;
import com.oracle.bmc.ocicontrolcenter.responses.ListMetricPropertiesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.ListNamespacesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.RequestSummarizedMetricDataResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OccMetricsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OccMetricsRxClient {
    OccMetricsAsyncClient client;

    OccMetricsRxClient(OccMetricsAsyncClient client) {
        this.client = client;
    }

    public Single<ListMetricPropertiesResponse> listMetricProperties(ListMetricPropertiesRequest request) {
        return Single.create(emitter -> this.client.listMetricProperties(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListNamespacesResponse> listNamespaces(ListNamespacesRequest request) {
        return Single.create(emitter -> this.client.listNamespaces(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RequestSummarizedMetricDataResponse> requestSummarizedMetricData(RequestSummarizedMetricDataRequest request) {
        return Single.create(emitter -> this.client.requestSummarizedMetricData(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

