/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ocvp;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ocvp.ClusterAsyncClient;
import com.oracle.bmc.ocvp.requests.CreateClusterRequest;
import com.oracle.bmc.ocvp.requests.DeleteClusterRequest;
import com.oracle.bmc.ocvp.requests.GetClusterRequest;
import com.oracle.bmc.ocvp.requests.ListClustersRequest;
import com.oracle.bmc.ocvp.requests.UpdateClusterRequest;
import com.oracle.bmc.ocvp.responses.CreateClusterResponse;
import com.oracle.bmc.ocvp.responses.DeleteClusterResponse;
import com.oracle.bmc.ocvp.responses.GetClusterResponse;
import com.oracle.bmc.ocvp.responses.ListClustersResponse;
import com.oracle.bmc.ocvp.responses.UpdateClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ClusterAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ClusterRxClient {
    ClusterAsyncClient client;

    ClusterRxClient(ClusterAsyncClient client) {
        this.client = client;
    }

    public Single<CreateClusterResponse> createCluster(CreateClusterRequest request) {
        return Single.create(emitter -> this.client.createCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteClusterResponse> deleteCluster(DeleteClusterRequest request) {
        return Single.create(emitter -> this.client.deleteCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetClusterResponse> getCluster(GetClusterRequest request) {
        return Single.create(emitter -> this.client.getCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListClustersResponse> listClusters(ListClustersRequest request) {
        return Single.create(emitter -> this.client.listClusters(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateClusterResponse> updateCluster(UpdateClusterRequest request) {
        return Single.create(emitter -> this.client.updateCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

