/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.onesubscription;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.onesubscription.SubscribedServiceAsyncClient;
import com.oracle.bmc.onesubscription.requests.GetSubscribedServiceRequest;
import com.oracle.bmc.onesubscription.requests.ListSubscribedServicesRequest;
import com.oracle.bmc.onesubscription.responses.GetSubscribedServiceResponse;
import com.oracle.bmc.onesubscription.responses.ListSubscribedServicesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={SubscribedServiceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SubscribedServiceRxClient {
    SubscribedServiceAsyncClient client;

    SubscribedServiceRxClient(SubscribedServiceAsyncClient client) {
        this.client = client;
    }

    public Single<GetSubscribedServiceResponse> getSubscribedService(GetSubscribedServiceRequest request) {
        return Single.create(emitter -> this.client.getSubscribedService(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscribedServicesResponse> listSubscribedServices(ListSubscribedServicesRequest request) {
        return Single.create(emitter -> this.client.listSubscribedServices(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

