/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.opa;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.opa.OpaInstanceAsyncClient;
import com.oracle.bmc.opa.requests.CancelWorkRequestRequest;
import com.oracle.bmc.opa.requests.ChangeOpaInstanceCompartmentRequest;
import com.oracle.bmc.opa.requests.CreateOpaInstanceRequest;
import com.oracle.bmc.opa.requests.DeleteOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetWorkRequestRequest;
import com.oracle.bmc.opa.requests.ListOpaInstancesRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opa.requests.UpdateOpaInstanceRequest;
import com.oracle.bmc.opa.responses.CancelWorkRequestResponse;
import com.oracle.bmc.opa.responses.ChangeOpaInstanceCompartmentResponse;
import com.oracle.bmc.opa.responses.CreateOpaInstanceResponse;
import com.oracle.bmc.opa.responses.DeleteOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetWorkRequestResponse;
import com.oracle.bmc.opa.responses.ListOpaInstancesResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opa.responses.UpdateOpaInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OpaInstanceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OpaInstanceRxClient {
    OpaInstanceAsyncClient client;

    OpaInstanceRxClient(OpaInstanceAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeOpaInstanceCompartmentResponse> changeOpaInstanceCompartment(ChangeOpaInstanceCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeOpaInstanceCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateOpaInstanceResponse> createOpaInstance(CreateOpaInstanceRequest request) {
        return Single.create(emitter -> this.client.createOpaInstance(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteOpaInstanceResponse> deleteOpaInstance(DeleteOpaInstanceRequest request) {
        return Single.create(emitter -> this.client.deleteOpaInstance(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOpaInstanceResponse> getOpaInstance(GetOpaInstanceRequest request) {
        return Single.create(emitter -> this.client.getOpaInstance(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOpaInstancesResponse> listOpaInstances(ListOpaInstancesRequest request) {
        return Single.create(emitter -> this.client.listOpaInstances(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateOpaInstanceResponse> updateOpaInstance(UpdateOpaInstanceRequest request) {
        return Single.create(emitter -> this.client.updateOpaInstance(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

